/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.libs.advancementapi;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import me.char321.sfadvancements.libs.advancementapi.Criteria;
import me.char321.sfadvancements.libs.advancementapi.display.Display;
import me.char321.sfadvancements.libs.advancementapi.trigger.Trigger;
import me.char321.sfadvancements.libs.advancementapi.trigger.TriggerWrapper;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Advancement {
    private final NamespacedKey key;
    @Expose
    @SerializedName(value="criteria")
    private final Map<String, Criteria> criteria = new HashMap<String, Criteria>();
    @Expose
    @SerializedName(value="requirements")
    private final List<String[]> requirements = new ArrayList<String[]>();
    @Expose
    @SerializedName(value="display")
    private Display display;
    @Expose
    @SerializedName(value="parent")
    private NamespacedKey parent;

    public Advancement(@NotNull NamespacedKey key) {
        Preconditions.checkNotNull((Object)key);
        this.key = key;
    }

    public Advancement(@NotNull Plugin plugin, @NotNull String id) {
        Preconditions.checkNotNull((Object)plugin);
        Preconditions.checkNotNull((Object)id);
        this.key = new NamespacedKey(plugin, id);
    }

    public void setParent(@NotNull NamespacedKey key) {
        Preconditions.checkNotNull((Object)key);
        this.parent = key;
    }

    public void setDisplay(@NotNull Consumer<Display> display) {
        Preconditions.checkNotNull(display);
        Display object = new Display();
        display.accept(object);
        this.display = object;
    }

    public void addRequirement(@NotNull Criteria criteria) {
        Preconditions.checkNotNull((Object)criteria);
        this.requirements.add(new String[]{criteria.getName()});
    }

    public void addRequirements(Criteria ... criterion) {
        Preconditions.checkNotNull((Object)criterion);
        this.requirements.add((String[])Arrays.stream(criterion).map(Criteria::getName).toArray(String[]::new));
    }

    @NotNull
    public <T extends Trigger> Criteria addCriteria(@NotNull String name, @NotNull TriggerWrapper<T> trigger, @NotNull Consumer<T> data) {
        Trigger object;
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(trigger);
        Preconditions.checkNotNull(data);
        if (this.criteria.containsKey(name)) {
            return this.criteria.get(name);
        }
        try {
            object = (Trigger)trigger.getClazz().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        data.accept(object);
        Criteria criteria = new Criteria(name, trigger, object);
        this.criteria.put(name, criteria);
        return criteria;
    }

    public NamespacedKey getKey() {
        return this.key;
    }
}

