/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.util;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.List;
import me.char321.sfadvancements.SFAdvancements;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ConfigUtils {
    private ConfigUtils() {
    }

    public static String translate(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public static ItemStack getItem(ConfigurationSection config, String path) {
        ItemStack item;
        if (config.isItemStack(path)) {
            return config.getItemStack(path);
        }
        ConfigurationSection itemSection = config.getConfigurationSection(path);
        if (itemSection == null) {
            String itemName = config.getString(path);
            if (itemName != null) {
                try {
                    return ConfigUtils.getTemplate(itemName).clone();
                }
                catch (IllegalArgumentException x) {
                    SFAdvancements.warn("invalid item name " + itemName);
                }
            }
            return null;
        }
        String type = itemSection.getString("type");
        try {
            item = ConfigUtils.getTemplate(type).clone();
        }
        catch (IllegalArgumentException x) {
            SFAdvancements.warn("invalid item type " + type);
            return null;
        }
        ItemMeta im = item.getItemMeta();
        String name = itemSection.getString("name");
        if (name != null) {
            im.setDisplayName(ConfigUtils.translate(name));
        }
        List lore = itemSection.getStringList("lore");
        lore.replaceAll(ConfigUtils::translate);
        im.setLore(lore);
        item.setItemMeta(im);
        return item;
    }

    public static ItemStack getTemplate(String id) {
        if (id == null || id.equals("AIR") || id.equals("null")) {
            return new ItemStack(Material.AIR);
        }
        SlimefunItem item = SlimefunItem.getById((String)id);
        if (item != null) {
            return item.getItem();
        }
        Material material = Material.getMaterial((String)id);
        if (material != null) {
            return new ItemStack(material);
        }
        throw new IllegalArgumentException();
    }
}

