/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.core.criteria.progress;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import me.char321.sfadvancements.SFAdvancements;
import me.char321.sfadvancements.api.Advancement;
import me.char321.sfadvancements.api.criteria.Criterion;
import me.char321.sfadvancements.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;

public class PlayerProgress {
    private final UUID player;
    private final Map<NamespacedKey, AdvancementProgress> progressMap = new HashMap<NamespacedKey, AdvancementProgress>();

    private PlayerProgress(UUID player) {
        this.player = player;
    }

    public static PlayerProgress get(Player player) {
        return PlayerProgress.get(player.getUniqueId());
    }

    public static PlayerProgress get(UUID player) {
        PlayerProgress res = new PlayerProgress(player);
        File advancementsFolder = new File(SFAdvancements.instance().getDataFolder(), "/advancements");
        File f = new File(advancementsFolder, player.toString() + ".json");
        if (f.exists()) {
            try {
                JsonObject object = JsonParser.parseReader((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8))).getAsJsonObject();
                res.loadFromObject(object);
            }
            catch (IOException e) {
                SFAdvancements.logger().log(Level.SEVERE, "Error reading progress file", e);
            }
        }
        return res;
    }

    public void doCriterion(Criterion criterion) {
        NamespacedKey adv = criterion.getAdvancement();
        this.progressMap.computeIfAbsent(adv, x$0 -> new AdvancementProgress((NamespacedKey)x$0));
        AdvancementProgress advProgress = this.progressMap.get(adv);
        if (advProgress.done) {
            return;
        }
        for (CriteriaProgress progress : advProgress.criteria) {
            if (!progress.id.equals(criterion.getId()) || progress.progress >= criterion.getCount()) continue;
            ++progress.progress;
            if (progress.progress < criterion.getCount()) continue;
            progress.done = true;
            advProgress.updateDone();
        }
    }

    public void completeCriterion(Criterion criterion) {
        NamespacedKey adv = criterion.getAdvancement();
        AdvancementProgress progress = this.progressMap.computeIfAbsent(adv, x$0 -> new AdvancementProgress((NamespacedKey)x$0));
        for (CriteriaProgress criteriaProgress : progress.criteria) {
            if (!criteriaProgress.id.equals(criterion.getId())) continue;
            if (criteriaProgress.done) {
                return;
            }
            criteriaProgress.done = true;
            criteriaProgress.progress = criterion.getCount();
            progress.updateDone();
        }
    }

    public int getCriterionProgress(Criterion cri) {
        NamespacedKey adv = cri.getAdvancement();
        if (!this.progressMap.containsKey(adv)) {
            return 0;
        }
        AdvancementProgress advProgress = this.progressMap.get(adv);
        for (CriteriaProgress progress : advProgress.criteria) {
            if (!progress.id.equals(cri.getId())) continue;
            return progress.progress;
        }
        throw new IllegalStateException();
    }

    public boolean revokeAdvancement(NamespacedKey adv) {
        if (!this.progressMap.containsKey(adv)) {
            return false;
        }
        this.progressMap.get((Object)adv).done = false;
        for (CriteriaProgress progress : this.progressMap.get((Object)adv).criteria) {
            progress.done = false;
            progress.progress = 0;
        }
        Utils.fromKey(adv).revoke(Bukkit.getPlayer((UUID)this.player));
        return true;
    }

    public List<NamespacedKey> getCompletedAdvancements() {
        ArrayList<NamespacedKey> res = new ArrayList<NamespacedKey>();
        for (Map.Entry<NamespacedKey, AdvancementProgress> entry : this.progressMap.entrySet()) {
            if (!entry.getValue().done) continue;
            res.add(entry.getKey());
        }
        return res;
    }

    private void loadFromObject(JsonObject object) {
        for (Map.Entry entry : object.entrySet()) {
            NamespacedKey advkey = NamespacedKey.fromString((String)((String)entry.getKey()));
            if (!Utils.isValidAdvancement(advkey)) {
                SFAdvancements.warn("unknown advancement in player progress: " + advkey);
                continue;
            }
            AdvancementProgress newprogress = new AdvancementProgress(advkey);
            this.progressMap.put(advkey, newprogress);
            newprogress.loadFromObject(((JsonElement)entry.getValue()).getAsJsonObject());
        }
    }

    public void save() throws IOException {
        File advancementsFolder = new File(SFAdvancements.instance().getDataFolder(), "/advancements");
        File f = new File(advancementsFolder, this.player + ".json");
        if (!f.exists()) {
            f.getParentFile().mkdirs();
            if (!f.createNewFile()) {
                throw new IOException("Could not create file " + f.getPath());
            }
        }
        try (JsonWriter writer = new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f, false), StandardCharsets.UTF_8)));){
            writer.beginObject();
            for (Map.Entry<NamespacedKey, AdvancementProgress> entry : this.progressMap.entrySet()) {
                writer.name(entry.getKey().toString());
                writer.beginObject();
                writer.name("done").value(entry.getValue().done);
                writer.name("criteria");
                writer.beginObject();
                for (CriteriaProgress criterion : entry.getValue().criteria) {
                    writer.name(criterion.id).value((long)criterion.progress);
                }
                writer.endObject();
                writer.endObject();
            }
            writer.endObject();
        }
    }

    public boolean isCompleted(NamespacedKey key) {
        if (!this.progressMap.containsKey(key)) {
            return false;
        }
        AdvancementProgress prog = this.progressMap.get(key);
        return prog.done;
    }

    class AdvancementProgress {
        Advancement adv;
        boolean done = false;
        CriteriaProgress[] criteria;

        AdvancementProgress(NamespacedKey adv) {
            this(Utils.fromKey(adv));
        }

        AdvancementProgress(Advancement adv) {
            this.adv = adv;
            this.criteria = new CriteriaProgress[adv.getCriteria().length];
            for (int i = 0; i < adv.getCriteria().length; ++i) {
                this.criteria[i] = new CriteriaProgress(adv.getCriteria()[i].getId());
            }
        }

        void updateDone() {
            for (CriteriaProgress criterion : this.criteria) {
                if (criterion.done) continue;
                return;
            }
            this.done = true;
            this.adv.onComplete(Bukkit.getPlayer((UUID)PlayerProgress.this.player));
        }

        void loadFromObject(JsonObject object) {
            this.done = object.get("done").getAsBoolean();
            JsonObject jsonCriteria = object.get("criteria").getAsJsonObject();
            this.criteria = new CriteriaProgress[this.adv.getCriteria().length];
            int i = 0;
            for (Criterion criterion : this.adv.getCriteria()) {
                CriteriaProgress criteriaProgress;
                JsonElement element = jsonCriteria.get(criterion.getId());
                if (element == null || !element.isJsonPrimitive()) {
                    criteriaProgress = new CriteriaProgress(criterion.getId(), 0);
                } else {
                    int progress = element.getAsInt();
                    criteriaProgress = new CriteriaProgress(criterion.getId(), progress);
                    criteriaProgress.done = progress >= criterion.getCount();
                }
                this.criteria[i] = criteriaProgress;
                ++i;
            }
        }
    }

    static class CriteriaProgress {
        String id;
        boolean done = false;
        int progress;

        CriteriaProgress(String id) {
            this(id, 0);
        }

        CriteriaProgress(String id, int progress) {
            this.id = id;
            this.progress = progress;
        }
    }
}

