/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.libs.advancementapi.display;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Icon {
    private static Method asNMSCopy;
    private static Field nbtField;
    @Expose
    @SerializedName(value="item")
    private NamespacedKey item;
    @Expose
    @SerializedName(value="nbt")
    private String nbt;

    public Icon() {
    }

    public Icon(@NotNull NamespacedKey item, String nbt) {
        Preconditions.checkNotNull((Object)item);
        this.item = item;
        this.nbt = nbt;
    }

    public Icon(@NotNull Material material, String nbt) {
        Preconditions.checkNotNull((Object)material);
        this.item = material.getKey();
        this.nbt = nbt;
    }

    public Icon(ItemStack item) {
        this.item = item.getType().getKey();
        try {
            if (nbtField == null) {
                this.nbt = null;
                return;
            }
            Object nmsstack = asNMSCopy.invoke(null, item);
            Object compound = nbtField.get(nmsstack);
            this.nbt = compound == null ? null : compound.toString();
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public void setItem(@NotNull Material material) {
        Preconditions.checkNotNull((Object)material);
        this.item = material.getKey();
    }

    public void setNbt(String nbt) {
        this.nbt = nbt;
    }

    static {
        try {
            String packageName = Bukkit.getServer().getClass().getPackage().getName();
            Class<?> aClass = Class.forName(packageName + ".inventory.CraftItemStack");
            asNMSCopy = aClass.getMethod("asNMSCopy", ItemStack.class);
            Object f = null;
            for (Field field : asNMSCopy.getReturnType().getDeclaredFields()) {
                if (!field.getType().getSimpleName().equals("NBTTagCompound")) continue;
                nbtField = field;
                nbtField.setAccessible(true);
                break;
            }
        }
        catch (ReflectiveOperationException x) {
            x.printStackTrace();
        }
    }
}

