/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.core.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import me.char321.sfadvancements.SFAdvancements;
import me.char321.sfadvancements.api.Advancement;
import me.char321.sfadvancements.core.command.SubCommand;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GrantCommand
implements SubCommand {
    @Override
    public boolean onExecute(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 3) {
            sender.sendMessage(ChatColor.RED + "Usage: /" + label + " grant <player> <advancement>");
            return false;
        }
        Player p = Bukkit.getPlayer((String)args[1]);
        if (p == null) {
            sender.sendMessage(ChatColor.RED + "Could not find player " + args[1]);
            return false;
        }
        if (args[2].equals("*") || args[2].equals("all")) {
            for (Advancement adv : SFAdvancements.getRegistry().getAdvancements().values()) {
                adv.complete(p);
            }
            sender.sendMessage("Successfully granted all advancements!");
            return true;
        }
        Advancement adv = SFAdvancements.getRegistry().getAdvancement(NamespacedKey.fromString((String)args[2]));
        if (adv == null) {
            sender.sendMessage(ChatColor.RED + "Could not find advancement " + args[2]);
            return false;
        }
        adv.complete(p);
        sender.sendMessage("Successfully granted advancement " + adv.getKey() + " to player " + p.getName());
        return true;
    }

    @Override
    @Nonnull
    public String getCommandName() {
        return "grant";
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        Player p;
        if (args.length == 2) {
            ArrayList<String> res = new ArrayList<String>();
            for (Player p2 : Bukkit.getOnlinePlayers()) {
                if (!p2.getName().contains(args[1])) continue;
                res.add(p2.getName());
            }
            return res;
        }
        if (args.length == 3 && (p = Bukkit.getPlayer((String)args[1])) != null) {
            ArrayList<String> res = new ArrayList<String>();
            res.add("*");
            res.add("all");
            for (Advancement adv : SFAdvancements.getRegistry().getAdvancements().values()) {
                String s;
                if (SFAdvancements.getAdvManager().isCompleted(p, adv) || !(s = adv.getKey().toString()).contains(args[2])) continue;
                res.add(s);
            }
            return res;
        }
        return Collections.emptyList();
    }
}

