/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import me.char321.sfadvancements.SFAdvancements;
import me.char321.sfadvancements.api.Advancement;
import org.bukkit.inventory.ItemStack;

public class AdvancementGroup {
    private final ItemStack display;
    private List<Advancement> advancements = new ArrayList<Advancement>();
    private String id;
    private String background;

    public AdvancementGroup(String id, ItemStack display) {
        this(id, display, "BEDROCK");
    }

    public AdvancementGroup(String id, ItemStack display, String background) {
        this.id = id;
        this.background = background;
        this.display = display;
    }

    public void register() {
        SFAdvancements.getRegistry().getAdvancementGroups().add(this);
    }

    public ItemStack getDisplayItem() {
        return this.display;
    }

    public List<Advancement> getAdvancements() {
        return Collections.unmodifiableList(this.advancements);
    }

    public List<Advancement> getVisibleAdvancements(UUID player) {
        return this.advancements.stream().filter(a -> !a.isHidden() || SFAdvancements.getAdvManager().isCompleted(player, (Advancement)a)).collect(Collectors.toList());
    }

    public String getId() {
        return this.id;
    }

    public String getBackground() {
        return this.background;
    }

    public void addAdvancement(Advancement advancement) {
        this.advancements.add(advancement);
    }
}

