/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.api.criteria;

import java.util.UUID;
import me.char321.sfadvancements.SFAdvancements;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class Criterion {
    private NamespacedKey advancement;
    private final String id;
    private final String name;
    private final int count;

    public Criterion(String id, int count, String name) {
        this.id = id;
        this.count = count;
        this.name = name;
    }

    public Criterion(String id) {
        this(id, 1);
    }

    public Criterion(String id, int count) {
        this(id, count, id);
    }

    public Criterion(String id, String name) {
        this(id, 1, name);
    }

    public static Criterion loadFromConfig(ConfigurationSection config) {
        String name;
        String id = config.getName();
        int amount = config.getInt("amount");
        if (amount == 0) {
            amount = 1;
        }
        if ((name = config.getString("name")) == null) {
            name = id;
        }
        name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
        return new Criterion(id, amount, name);
    }

    public String getId() {
        return this.id;
    }

    public int getCount() {
        return this.count;
    }

    public String getName() {
        return this.name;
    }

    public NamespacedKey getAdvancement() {
        return this.advancement;
    }

    public void setAdvancement(NamespacedKey advancement) {
        this.advancement = advancement;
    }

    public void register() {
        SFAdvancements.getRegistry().getCompleter(this).register(this);
    }

    public void perform(UUID p) {
        SFAdvancements.getAdvManager().getProgress(p).doCriterion(this);
    }

    public void perform(Player p) {
        this.perform(p.getUniqueId());
    }

    public void complete(Player p) {
        SFAdvancements.getAdvManager().getProgress(p).completeCriterion(this);
    }
}

