/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.libs.advancementapi.display;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.function.Consumer;
import me.char321.sfadvancements.libs.advancementapi.display.BackgroundType;
import me.char321.sfadvancements.libs.advancementapi.display.FrameType;
import me.char321.sfadvancements.libs.advancementapi.display.Icon;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;

public class Display {
    @Expose
    @SerializedName(value="title")
    private BaseComponent title = new TextComponent("UNDEFINED");
    @Expose
    @SerializedName(value="description")
    private BaseComponent description = new TextComponent("UNDEFINED");
    @Expose
    @SerializedName(value="icon")
    private Icon icon;
    @Expose
    @SerializedName(value="background")
    private NamespacedKey background;
    @Expose
    @SerializedName(value="frame")
    private FrameType frame;
    @Expose
    @SerializedName(value="show_toast")
    private boolean toast = true;
    @Expose
    @SerializedName(value="announce_to_chat")
    private boolean announce = true;
    @Expose
    @SerializedName(value="hidden")
    private boolean hidden = false;

    public void setTitle(@NotNull BaseComponent title) {
        Preconditions.checkNotNull((Object)title);
        this.title = title;
    }

    public void setTitle(@NotNull String title) {
        Preconditions.checkNotNull((Object)title);
        this.title = new TextComponent(title);
    }

    public void setDescription(@NotNull BaseComponent description) {
        Preconditions.checkNotNull((Object)description);
        this.description = description;
    }

    public void setDescription(@NotNull String description) {
        Preconditions.checkNotNull((Object)description);
        this.description = new TextComponent(description);
    }

    public void setFrame(@NotNull FrameType frame) {
        Preconditions.checkNotNull((Object)((Object)frame));
        this.frame = frame;
    }

    public void setIcon(@NotNull Icon icon) {
        Preconditions.checkNotNull((Object)icon);
        this.icon = icon;
    }

    public void setIcon(@NotNull Consumer<Icon> consumer) {
        Preconditions.checkNotNull(consumer);
        Icon icon = new Icon();
        consumer.accept(icon);
        this.icon = icon;
    }

    public void setIcon(@NotNull Material material) {
        this.icon = new Icon(material, null);
    }

    public void setIcon(@NotNull Material material, String nbt) {
        this.icon = new Icon(material, nbt);
    }

    public void setBackground(@NotNull BackgroundType background) {
        Preconditions.checkNotNull((Object)((Object)background));
        this.background = background.getTexture();
    }

    public void setBackground(@NotNull NamespacedKey key) {
        Preconditions.checkNotNull((Object)key);
        this.background = key;
    }

    public void setToast(boolean toast) {
        this.toast = toast;
    }

    public void setAnnounce(boolean announce) {
        this.announce = announce;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}

