/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.core.criteria.completer;

import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.char321.sfadvancements.SFAdvancements;
import me.char321.sfadvancements.api.criteria.Criterion;
import me.char321.sfadvancements.api.criteria.InventoryCriterion;
import me.char321.sfadvancements.core.criteria.completer.CriterionCompleter;
import me.char321.sfadvancements.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class InventoryCriterionCompleter
implements CriterionCompleter,
Listener {
    private final Map<Material, Set<InventoryCriterion>> criteria = new EnumMap<Material, Set<InventoryCriterion>>(Material.class);

    public InventoryCriterionCompleter() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)SFAdvancements.instance());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventory(EntityPickupItemEvent e) {
        LivingEntity entity = e.getEntity();
        if (entity instanceof Player) {
            Utils.runLater(() -> this.lambda$onInventory$0((Entity)entity), 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent e) {
        this.onInventory1((Player)e.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent e) {
        this.onInventory1((Player)e.getPlayer());
    }

    public void onInventory1(Player p) {
        PlayerInventory inv = p.getInventory();
        Map<ItemStack, Integer> contents = Utils.getContents((Inventory)inv);
        for (ItemStack item : contents.keySet()) {
            Material material = item.getType();
            if (!this.criteria.containsKey(material)) continue;
            for (InventoryCriterion criterion : this.criteria.get(material)) {
                if (!SlimefunUtils.isItemSimilar((ItemStack)criterion.getItem(), (ItemStack)item, (boolean)false, (boolean)false) || contents.get(item) < criterion.getAmount()) continue;
                criterion.perform(p);
            }
        }
    }

    @Override
    public void register(Criterion criterion) {
        if (!(criterion instanceof InventoryCriterion)) {
            throw new IllegalArgumentException("criterion must be an interactcriterion");
        }
        InventoryCriterion criterion1 = (InventoryCriterion)criterion;
        Material m = criterion1.getItem().getType();
        this.criteria.computeIfAbsent(m, k -> new HashSet());
        this.criteria.get(m).add(criterion1);
    }

    @Override
    public Class<? extends Criterion> getCriterionClass() {
        return InventoryCriterion.class;
    }

    @Override
    public void reload() {
        this.criteria.clear();
    }

    private /* synthetic */ void lambda$onInventory$0(Entity entity) {
        this.onInventory1((Player)entity);
    }
}

