/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.core.criteria.completer;

import io.github.thebusybiscuit.slimefun4.api.events.ResearchUnlockEvent;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.api.researches.Research;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.char321.sfadvancements.SFAdvancements;
import me.char321.sfadvancements.api.criteria.Criterion;
import me.char321.sfadvancements.api.criteria.ResearchCriterion;
import me.char321.sfadvancements.core.criteria.completer.CriterionCompleter;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class ResearchCriterionCompleter
implements CriterionCompleter,
Listener {
    private final Map<NamespacedKey, Set<ResearchCriterion>> criteria = new HashMap<NamespacedKey, Set<ResearchCriterion>>();

    public ResearchCriterionCompleter() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)SFAdvancements.instance());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        PlayerProfile.get((OfflinePlayer)p, profile -> {
            for (Research research : profile.getResearches()) {
                this.performCriteria(p, research);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerResearch(ResearchUnlockEvent e) {
        this.performCriteria(e.getPlayer(), e.getResearch());
    }

    private void performCriteria(Player player, Research research) {
        Set<ResearchCriterion> allcriteria = this.criteria.get(research.getKey());
        if (allcriteria == null) {
            return;
        }
        for (ResearchCriterion criterion : allcriteria) {
            criterion.perform(player);
        }
    }

    @Override
    public void register(Criterion criterion) {
        if (!(criterion instanceof ResearchCriterion)) {
            throw new IllegalArgumentException("criterion must be an " + this.getCriterionClass().getName());
        }
        ResearchCriterion criterion1 = (ResearchCriterion)criterion;
        NamespacedKey research = criterion1.getResearch();
        this.criteria.computeIfAbsent(research, k -> new HashSet());
        this.criteria.get(research).add(criterion1);
    }

    @Override
    public Class<? extends Criterion> getCriterionClass() {
        return ResearchCriterion.class;
    }

    @Override
    public void reload() {
        this.criteria.clear();
    }
}

