/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.core.criteria.completer;

import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import me.char321.sfadvancements.SFAdvancements;
import me.char321.sfadvancements.api.criteria.Criterion;
import me.char321.sfadvancements.api.criteria.PlaceCriterion;
import me.char321.sfadvancements.core.criteria.completer.CriterionCompleter;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlaceCriterionCompleter
implements CriterionCompleter,
Listener {
    private EnumMap<Material, Set<PlaceCriterion>> criteria = new EnumMap(Material.class);

    public PlaceCriterionCompleter() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)SFAdvancements.instance());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlace(BlockPlaceEvent e) {
        Material m = e.getItemInHand().getType();
        Set<PlaceCriterion> all = this.criteria.get(m);
        if (all == null) {
            return;
        }
        for (PlaceCriterion criterion : all) {
            if (!SlimefunUtils.isItemSimilar((ItemStack)criterion.getItem(), (ItemStack)e.getItemInHand(), (boolean)false, (boolean)false)) continue;
            criterion.perform(e.getPlayer());
        }
    }

    @Override
    public Class<? extends Criterion> getCriterionClass() {
        return PlaceCriterion.class;
    }

    @Override
    public void register(Criterion criterion) {
        if (!(criterion instanceof PlaceCriterion)) {
            throw new IllegalArgumentException("criterion must be an " + this.getCriterionClass().getName());
        }
        PlaceCriterion placeCriterion = (PlaceCriterion)criterion;
        Material m = placeCriterion.getItem().getType();
        this.criteria.computeIfAbsent(m, k -> new HashSet());
        this.criteria.get(m).add(placeCriterion);
    }

    @Override
    public void reload() {
        this.criteria.clear();
    }
}

