/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.libs.advancementapi.trigger;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.function.Consumer;
import me.char321.sfadvancements.libs.advancementapi.AdvancementException;
import me.char321.sfadvancements.libs.advancementapi.data.ItemData;
import me.char321.sfadvancements.libs.advancementapi.trigger.Trigger;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;

public class BeeNestDestroyed
implements Trigger {
    @Expose
    @SerializedName(value="block")
    private Material block;
    @Expose
    @SerializedName(value="item")
    private ItemData item;
    @Expose
    @SerializedName(value="numBeesInside")
    private int numBeesInside;

    public void setBlock(@NotNull Material block) {
        Preconditions.checkNotNull((Object)block);
        if (!block.isBlock()) {
            throw new AdvancementException(block.getKey() + " is not a block");
        }
        if (block != Material.BEE_NEST && block != Material.BEEHIVE) {
            throw new AdvancementException(block.getKey() + " is not a bee nest or beehive");
        }
        this.block = block;
    }

    public void withItem(@NotNull Consumer<ItemData> consumer) {
        Preconditions.checkNotNull(consumer);
        this.item = new ItemData();
        consumer.accept(this.item);
    }

    public void withItem(@NotNull Material material) {
        Preconditions.checkNotNull((Object)material);
        this.withItem((ItemData item) -> item.setType(material));
    }

    public void withBeeCount(int amount) {
        this.numBeesInside = amount;
    }
}

