/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.core.command;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.char321.sfadvancements.SFAdvancements;
import me.char321.sfadvancements.core.command.DumpItemCommand;
import me.char321.sfadvancements.core.command.GrantCommand;
import me.char321.sfadvancements.core.command.GuiCommand;
import me.char321.sfadvancements.core.command.ImportCommand;
import me.char321.sfadvancements.core.command.ReloadCommand;
import me.char321.sfadvancements.core.command.RevokeCommand;
import me.char321.sfadvancements.core.command.SFATabCompleter;
import me.char321.sfadvancements.core.command.SaveCommand;
import me.char321.sfadvancements.core.command.SubCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class SFACommand
implements CommandExecutor {
    private final List<SubCommand> subcommands = new LinkedList<SubCommand>();

    public SFACommand(SFAdvancements plugin) {
        this.subcommands.add(new SaveCommand());
        this.subcommands.add(new RevokeCommand());
        this.subcommands.add(new GrantCommand());
        this.subcommands.add(new GuiCommand());
        this.subcommands.add(new DumpItemCommand());
        this.subcommands.add(new ReloadCommand());
        this.subcommands.add(new ImportCommand());
        plugin.getCommand("sfadvancements").setTabCompleter((TabCompleter)new SFATabCompleter(this));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 0) {
            for (SubCommand subcmd : this.subcommands) {
                if (!args[0].equalsIgnoreCase(subcmd.getCommandName())) continue;
                if (sender.hasPermission("sfa.command." + subcmd.getCommandName())) {
                    return subcmd.onExecute(sender, command, label, args);
                }
                sender.sendMessage("You do not have permission to use this command.");
                return false;
            }
            sender.sendMessage("Unknown subcommand! Available subcommands are: " + this.subcommands.stream().map(SubCommand::getCommandName).collect(Collectors.joining(", ")));
            return false;
        }
        sender.sendMessage("SFAdvancements version " + SFAdvancements.instance().getDescription().getVersion());
        return true;
    }

    public List<SubCommand> getSubCommands() {
        return this.subcommands;
    }
}

