/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.api.criteria;

import java.util.function.Function;
import me.char321.sfadvancements.SFAdvancements;
import me.char321.sfadvancements.api.criteria.BlockBreakCriterion;
import me.char321.sfadvancements.api.criteria.ConsumeCriterion;
import me.char321.sfadvancements.api.criteria.Criterion;
import me.char321.sfadvancements.api.criteria.InteractCriterion;
import me.char321.sfadvancements.api.criteria.InventoryCriterion;
import me.char321.sfadvancements.api.criteria.MobKillCriterion;
import me.char321.sfadvancements.api.criteria.MultiBlockCriterion;
import me.char321.sfadvancements.api.criteria.PlaceCriterion;
import me.char321.sfadvancements.api.criteria.ResearchCriterion;
import me.char321.sfadvancements.api.criteria.SearchCriterion;
import org.bukkit.configuration.ConfigurationSection;

public class CriteriaTypes {
    private CriteriaTypes() {
    }

    public static void loadDefaultCriteria() {
        CriteriaTypes.putType("consume", ConsumeCriterion::loadFromConfig);
        CriteriaTypes.putType("interact", InteractCriterion::loadFromConfig);
        CriteriaTypes.putType("inventory", InventoryCriterion::loadFromConfig);
        CriteriaTypes.putType("mobkill", MobKillCriterion::loadFromConfig);
        CriteriaTypes.putType("multiblock", MultiBlockCriterion::loadFromConfig);
        CriteriaTypes.putType("place", PlaceCriterion::loadFromConfig);
        CriteriaTypes.putType("research", ResearchCriterion::loadFromConfig);
        CriteriaTypes.putType("none", Criterion::loadFromConfig);
        CriteriaTypes.putType("search", SearchCriterion::loadFromConfig);
        CriteriaTypes.putType("break", BlockBreakCriterion::loadFromConfig);
    }

    public static void putType(String type, Function<ConfigurationSection, Criterion> criterionFromConfig) {
        SFAdvancements.getRegistry().getCriterionTypes().put(type, criterionFromConfig);
    }

    public static Criterion loadFromConfig(String id, ConfigurationSection config) {
        String type = config.getString("type");
        if (type == null) {
            SFAdvancements.warn("You must specify a type for criterion " + id + " in advancements.yml");
            return null;
        }
        Function<ConfigurationSection, Criterion> function = SFAdvancements.getRegistry().getCriterionTypes().get(type);
        if (function == null) {
            SFAdvancements.warn("unknown criterion type: " + type);
            return null;
        }
        return function.apply(config);
    }
}

