/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.core.criteria.completer;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.char321.sfadvancements.SFAdvancements;
import me.char321.sfadvancements.api.criteria.Criterion;
import me.char321.sfadvancements.api.criteria.InteractCriterion;
import me.char321.sfadvancements.core.criteria.completer.CriterionCompleter;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class InteractCriterionCompleter
implements Listener,
CriterionCompleter {
    private final Map<Material, Set<InteractCriterion>> criteria = new EnumMap<Material, Set<InteractCriterion>>(Material.class);

    public InteractCriterionCompleter() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)SFAdvancements.instance());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInteract(PlayerRightClickEvent e) {
        ItemStack clicked = e.getItem();
        Set<InteractCriterion> allCriteria = this.criteria.get(clicked.getType());
        if (allCriteria == null) {
            return;
        }
        for (InteractCriterion criterion : allCriteria) {
            if (!SlimefunUtils.isItemSimilar((ItemStack)clicked, (ItemStack)criterion.getItem(), (boolean)false, (boolean)false)) continue;
            criterion.perform(e.getPlayer());
        }
    }

    @Override
    public void register(Criterion criterion) {
        if (!(criterion instanceof InteractCriterion)) {
            throw new IllegalArgumentException("criterion must be an interactcriterion");
        }
        InteractCriterion criterion1 = (InteractCriterion)criterion;
        Material m = criterion1.getItem().getType();
        this.criteria.computeIfAbsent(m, k -> new HashSet());
        this.criteria.get(m).add(criterion1);
    }

    @Override
    public Class<? extends Criterion> getCriterionClass() {
        return InteractCriterion.class;
    }

    @Override
    public void reload() {
        this.criteria.clear();
    }
}

