/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.api.criteria;

import me.char321.sfadvancements.SFAdvancements;
import me.char321.sfadvancements.api.criteria.Criterion;
import me.char321.sfadvancements.util.ConfigUtils;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class InventoryCriterion
extends Criterion {
    private final ItemStack item;
    private final int amount;

    public static InventoryCriterion loadFromConfig(ConfigurationSection config) {
        String id = config.getName();
        String name = config.getString("name");
        if (name == null) {
            name = id;
        }
        name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
        ItemStack item = ConfigUtils.getItem(config, "item");
        if (item == null) {
            SFAdvancements.warn("unknown item for inventory criterion " + id);
            return null;
        }
        int amount = config.getInt("amount");
        if (amount <= 0) {
            amount = 1;
        }
        return new InventoryCriterion(id, name, item, amount);
    }

    public InventoryCriterion(String id, String name, ItemStack item, int amount) {
        super(id, name);
        item = item.clone();
        item.setAmount(1);
        this.item = item;
        this.amount = amount;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getAmount() {
        return this.amount;
    }
}

