/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.GitHubBuildsUpdater;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.char321.sfadvancements.api.AdvancementBuilder;
import me.char321.sfadvancements.api.AdvancementGroup;
import me.char321.sfadvancements.api.criteria.CriteriaTypes;
import me.char321.sfadvancements.core.AdvManager;
import me.char321.sfadvancements.core.AdvancementsItemGroup;
import me.char321.sfadvancements.core.command.SFACommand;
import me.char321.sfadvancements.core.criteria.completer.CriterionCompleter;
import me.char321.sfadvancements.core.criteria.completer.DefaultCompleters;
import me.char321.sfadvancements.core.gui.AdvGUIManager;
import me.char321.sfadvancements.core.registry.AdvancementsRegistry;
import me.char321.sfadvancements.core.tasks.AutoSaveTask;
import me.char321.sfadvancements.libs.bstats.bukkit.Metrics;
import me.char321.sfadvancements.libs.bstats.charts.SimplePie;
import me.char321.sfadvancements.util.ConfigUtils;
import me.char321.sfadvancements.util.Utils;
import me.char321.sfadvancements.vanilla.VanillaHook;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;

public final class SFAdvancements
extends JavaPlugin
implements SlimefunAddon {
    private static SFAdvancements instance;
    private final AdvManager advManager = new AdvManager();
    private final AdvGUIManager guiManager = new AdvGUIManager();
    private final AdvancementsRegistry registry = new AdvancementsRegistry();
    private final VanillaHook vanillaHook = new VanillaHook();
    private Config config;
    private YamlConfiguration advancementConfig;
    private YamlConfiguration groupConfig;
    private boolean testing = false;

    public SFAdvancements() {
    }

    public SFAdvancements(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
        this.testing = true;
    }

    public void onEnable() {
        instance = this;
        this.config = new Config((Plugin)this);
        this.autoUpdate();
        this.getCommand("sfadvancements").setExecutor((CommandExecutor)new SFACommand(this));
        Bukkit.getPluginManager().registerEvents((Listener)this.guiManager, (Plugin)this);
        AdvancementsItemGroup.init(this);
        DefaultCompleters.registerDefaultCompleters();
        CriteriaTypes.loadDefaultCriteria();
        SFAdvancements.info("Starting auto-save task...");
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new AutoSaveTask(), 6000L, 6000L);
        if (!this.testing) {
            Metrics metrics = new Metrics(this, 14130);
            metrics.addCustomChart(new SimplePie("AdvancementAPI enabled", () -> this.config.getBoolean("use-advancements-api") ? "true" : "false"));
        }
        SFAdvancements.info("Waiting for server start...");
        Utils.runLater(() -> {
            SFAdvancements.info("Loading groups from config...");
            this.loadGroups();
            SFAdvancements.info("Loading advancements from config...");
            this.loadAdvancements();
            if (!this.testing && this.config.getBoolean("use-advancements-api")) {
                this.vanillaHook.init();
            }
        }, 0L);
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        try {
            this.advManager.save();
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, e, () -> "Could not save advancements");
        }
    }

    private void autoUpdate() {
        if (this.config.getBoolean("auto-update") && !this.getDescription().getVersion().contains("MODIFIED")) {
            SFAdvancements.info("Checking for updates...");
            GitHubBuildsUpdater updater = new GitHubBuildsUpdater((Plugin)this, this.getFile(), "qwertyuioplkjhgfd/SlimefunAdvancements/main");
            updater.start();
        }
    }

    public void reload() {
        this.config.reload();
        this.advManager.getPlayerMap().clear();
        this.registry.getAdvancements().clear();
        this.registry.getAdvancementGroups().clear();
        this.registry.getCompleters().values().forEach(CriterionCompleter::reload);
        this.loadGroups();
        this.loadAdvancements();
        if (!this.testing && this.config.getBoolean("use-advancements-api")) {
            this.vanillaHook.reload();
        }
    }

    public void loadGroups() {
        File groupFile = new File(this.getDataFolder(), "groups.yml");
        if (!groupFile.exists()) {
            this.saveResource("groups.yml", false);
        }
        this.groupConfig = YamlConfiguration.loadConfiguration((File)groupFile);
        for (String key : this.groupConfig.getKeys(false)) {
            String background = this.groupConfig.getString(key + ".background", "BEDROCK");
            ItemStack display = ConfigUtils.getItem((ConfigurationSection)this.groupConfig, key + ".display");
            AdvancementGroup group = new AdvancementGroup(key, display, background);
            group.register();
        }
    }

    public void loadAdvancements() {
        File advancementsFile = new File(this.getDataFolder(), "advancements.yml");
        if (!advancementsFile.exists()) {
            this.saveResource("advancements.yml", false);
        }
        this.advancementConfig = YamlConfiguration.loadConfiguration((File)advancementsFile);
        for (String key : this.advancementConfig.getKeys(false)) {
            AdvancementBuilder builder = AdvancementBuilder.loadFromConfig(key, this.advancementConfig.getConfigurationSection(key));
            if (builder == null) continue;
            builder.register();
        }
    }

    @Nonnull
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    @Nullable
    public String getBugTrackerURL() {
        return null;
    }

    public static SFAdvancements instance() {
        return instance;
    }

    public static AdvManager getAdvManager() {
        return SFAdvancements.instance.advManager;
    }

    public static AdvGUIManager getGuiManager() {
        return SFAdvancements.instance.guiManager;
    }

    public static AdvancementsRegistry getRegistry() {
        return SFAdvancements.instance.registry;
    }

    public static VanillaHook getVanillaHook() {
        return SFAdvancements.instance.vanillaHook;
    }

    public static Config getMainConfig() {
        return SFAdvancements.instance.config;
    }

    public YamlConfiguration getAdvancementConfig() {
        return this.advancementConfig;
    }

    public YamlConfiguration getGroupsConfig() {
        return this.groupConfig;
    }

    public boolean isTesting() {
        return this.testing;
    }

    public static Logger logger() {
        return instance.getLogger();
    }

    public static void info(String msg) {
        instance.getLogger().info(msg);
    }

    public static void warn(String msg) {
        instance.getLogger().warning(msg);
    }

    public static void error(String msg) {
        instance.getLogger().severe(msg);
    }
}

