/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.slimefunaccelerator.core.listeners;

import com.balugaq.slimefunaccelerator.api.AcceleratorSettings;
import com.balugaq.slimefunaccelerator.api.utils.Accelerates;
import com.balugaq.slimefunaccelerator.api.utils.ReflectionUtil;
import com.balugaq.slimefunaccelerator.core.listeners.ExtraTickerCNVersion;
import com.balugaq.slimefunaccelerator.core.managers.AcceleratesLoader;
import com.balugaq.slimefunaccelerator.implementation.SlimefunAccelerator;
import com.xzavier0722.mc.plugin.slimefun4.storage.controller.SlimefunBlockData;
import com.xzavier0722.mc.plugin.slimefun4.storage.util.StorageCacheUtils;
import io.github.thebusybiscuit.slimefun4.api.events.BlockPlacerPlaceEvent;
import io.github.thebusybiscuit.slimefun4.api.events.SlimefunItemRegistryFinalizedEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Accelerator
implements Listener {
    public static final int EXTRA_TICKER_FLAG = 1;
    public static final Map<String, Set<Location>> allTickerLocations = new ConcurrentHashMap<String, Set<Location>>(16);
    public static final Map<SlimefunItem, BlockTicker> originalTickers = new ConcurrentHashMap<SlimefunItem, BlockTicker>(16);
    public static final boolean isCNSlimefun = SlimefunAccelerator.getInstance().getIntegrationManager().isCNSlimefun();
    public static final Map<String, AtomicBoolean> running = new ConcurrentHashMap<String, AtomicBoolean>(16);
    public static final Map<String, Set<Location>> tickLocations = new ConcurrentHashMap<String, Set<Location>>(16);
    public static final Set<String> extraTickers = new HashSet<String>(16);
    public static final BiConsumer<String, Set<SlimefunItem>> onAccelerate = (group, items) -> {
        HashSet<Location> queue;
        AtomicBoolean s = running.computeIfAbsent((String)group, k -> new AtomicBoolean(false));
        if (s.compareAndSet(false, true)) {
            return;
        }
        for (SlimefunItem slimefunItem : items) {
            BlockTicker blockTicker;
            if (slimefunItem.isDisabled() || (blockTicker = Accelerates.getTickers().get(slimefunItem.getId())) == null) continue;
            blockTicker.uniqueTick();
        }
        AcceleratorSettings settings = Accelerates.getAccelerateSettings().get(group);
        if (settings == null) {
            return;
        }
        Set<Location> groupSet = tickLocations.get(group);
        Set<Location> set = groupSet;
        synchronized (set) {
            queue = new HashSet<Location>(groupSet);
        }
        for (Location location : queue) {
            BlockTicker ticker;
            Set<Location> extra;
            SlimefunBlockData config;
            SlimefunItem item;
            if (location == null || (item = isCNSlimefun ? StorageCacheUtils.getSfItem((Location)location) : BlockStorage.check((Location)location)) == null || !settings.isTickUnload() && !location.getChunk().isLoaded() || item.isDisabledIn(location.getWorld())) continue;
            if (isCNSlimefun) {
                config = StorageCacheUtils.getBlock((Location)location);
                if (config == null) {
                    if (((int)location.getYaw() & 1) == 0 || (extra = allTickerLocations.get(item.getId())) == null) continue;
                    Set<Location> set2 = extra;
                    synchronized (set2) {
                        extra.remove(location);
                        continue;
                    }
                }
                ticker = Accelerates.getTickers().get(item.getId());
                if (ticker == null) continue;
                try {
                    ticker.tick(location.getBlock(), item, config);
                }
                catch (Throwable e) {
                    SlimefunAccelerator.getInstance().getLogger().severe("An error occurred while ticking " + item.getId());
                    SlimefunAccelerator.getInstance().getLogger().severe(e.toString());
                    e.printStackTrace();
                }
                continue;
            }
            config = BlockStorage.getLocationInfo((Location)location);
            if (config == null) {
                if (((int)location.getYaw() & 1) == 0 || (extra = allTickerLocations.get(item.getId())) == null) continue;
                Set<Location> e = extra;
                synchronized (e) {
                    extra.remove(location);
                    continue;
                }
            }
            ticker = Accelerates.getTickers().get(item.getId());
            if (ticker == null) continue;
            try {
                ticker.tick(location.getBlock(), item, (Config)config);
            }
            catch (Throwable e) {
                SlimefunAccelerator.getInstance().getLogger().severe("An error occurred while ticking " + item.getId());
                SlimefunAccelerator.getInstance().getLogger().severe(e.toString());
                e.printStackTrace();
            }
        }
        tickLocations.get(group).clear();
        running.get(group).set(false);
    };

    /*
     * WARNING - void declaration
     */
    public static void load() {
        String group;
        SlimefunAccelerator.getInstance().getLogger().info("Loading accelerates...");
        AcceleratesLoader.loadAccelerates();
        HashMap<String, Object> allSettings = new HashMap<String, Object>();
        Map<String, Set<SlimefunItem>> accelerates = Accelerates.getAccelerates();
        for (Map.Entry<String, Set<SlimefunItem>> entry : accelerates.entrySet()) {
            void var7_11;
            group = entry.getKey();
            tickLocations.put(group, ConcurrentHashMap.newKeySet());
            running.put(group, new AtomicBoolean(false));
            Set<SlimefunItem> items = entry.getValue();
            Object settings = Accelerates.getAccelerateSettings().get(group);
            if (settings == null) {
                settings = new AcceleratorSettings();
            }
            allSettings.put(group, settings);
            if (((AcceleratorSettings)settings).isEnabledExtraTicker()) {
                for (SlimefunItem slimefunItem : items) {
                    extraTickers.add(slimefunItem.getId());
                }
            }
            for (SlimefunItem slimefunItem : items) {
                final BlockTicker blockTicker = slimefunItem.getBlockTicker();
                if (blockTicker == null) continue;
                originalTickers.put(slimefunItem, blockTicker);
                ItemState state = slimefunItem.getState();
                ReflectionUtil.setValue(slimefunItem, SlimefunItem.class, "state", ItemState.UNREGISTERED);
                if (isCNSlimefun) {
                    if (((AcceleratorSettings)settings).isRemoveOriginalTicker()) {
                        slimefunItem.addItemHandler(new ItemHandler[]{new BlockTicker(){

                            public boolean isSynchronized() {
                                return false;
                            }

                            public void tick(Block block, SlimefunItem slimefunItem, SlimefunBlockData config) {
                            }
                        }});
                    } else {
                        slimefunItem.addItemHandler(new ItemHandler[]{new BlockTicker(){

                            public boolean isSynchronized() {
                                return blockTicker.isSynchronized();
                            }

                            public void tick(@NotNull Block block, SlimefunItem slimefunItem, SlimefunBlockData config) {
                                Location location = block.getLocation();
                                Set<Location> queue = tickLocations.get(group);
                                queue.add(location);
                            }
                        }});
                    }
                } else if (((AcceleratorSettings)settings).isRemoveOriginalTicker()) {
                    slimefunItem.addItemHandler(new ItemHandler[]{new BlockTicker(){

                        public boolean isSynchronized() {
                            return false;
                        }

                        public void tick(Block block, SlimefunItem slimefunItem, Config config) {
                        }
                    }});
                } else {
                    slimefunItem.addItemHandler(new ItemHandler[]{new BlockTicker(){

                        public boolean isSynchronized() {
                            return blockTicker.isSynchronized();
                        }

                        public void tick(@NotNull Block block, SlimefunItem slimefunItem, Config config) {
                            Location location = block.getLocation();
                            Set<Location> queue = tickLocations.get(group);
                            queue.add(location);
                        }
                    }});
                }
                ReflectionUtil.setValue(slimefunItem, SlimefunItem.class, "state", state);
            }
            if (((AcceleratorSettings)settings).isAsync()) {
                int n = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)SlimefunAccelerator.getInstance(), () -> onAccelerate.accept(group, items), (long)((AcceleratorSettings)settings).getDelay(), (long)((AcceleratorSettings)settings).getPeriod()).getTaskId();
            } else {
                int n = Bukkit.getScheduler().runTaskTimer((Plugin)SlimefunAccelerator.getInstance(), () -> onAccelerate.accept(group, items), (long)((AcceleratorSettings)settings).getDelay(), (long)((AcceleratorSettings)settings).getPeriod()).getTaskId();
            }
            Accelerates.getTaskIds().put(group, (int)var7_11);
        }
        if (isCNSlimefun) {
            allTickerLocations.putAll(ExtraTickerCNVersion.getAllTickLocations());
        } else {
            for (World world : Bukkit.getWorlds()) {
                Map storage;
                BlockStorage blockStorage = BlockStorage.getStorage((World)world);
                if (blockStorage == null || (storage = (Map)ReflectionUtil.invokeMethod(blockStorage, "getRawStorage", new Object[0])) == null) continue;
                for (Map.Entry entry : storage.entrySet()) {
                    Location location = (Location)entry.getKey();
                    SlimefunItem slimefunItem = BlockStorage.check((Location)location);
                    if (slimefunItem == null || !extraTickers.contains(slimefunItem.getId())) continue;
                    allTickerLocations.computeIfAbsent(slimefunItem.getId(), k -> ConcurrentHashMap.newKeySet()).add(location);
                }
            }
        }
        for (Map.Entry<String, Set<Object>> entry : allSettings.entrySet()) {
            group = entry.getKey();
            AcceleratorSettings settings = (AcceleratorSettings)((Object)entry.getValue());
            Set<SlimefunItem> items = accelerates.get(entry.getKey());
            HashSet<String> hashSet = new HashSet<String>();
            for (SlimefunItem slimefunItem : items) {
                hashSet.add(slimefunItem.getId());
            }
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)SlimefunAccelerator.getInstance(), () -> {
                for (String id : ids) {
                    Set<Location> locations;
                    SlimefunItem slimefunItem = SlimefunItem.getById((String)id);
                    if (slimefunItem == null || slimefunItem.isDisabled() || (locations = allTickerLocations.get(id)) == null) continue;
                    for (Location location : locations) {
                        Set<Location> queue;
                        if (!settings.isTickUnload() && !location.getChunk().isLoaded() || slimefunItem.isDisabledIn(location.getWorld())) continue;
                        Location clone = location.clone();
                        clone.setYaw(1.0f);
                        Set<Location> set = queue = tickLocations.get(group);
                        synchronized (set) {
                            queue.add(clone);
                        }
                    }
                }
            }, (long)settings.getExtraTickerDelay(), (long)settings.getExtraTickerPeriod());
        }
    }

    public static void shutdown() {
        for (int taskId : Accelerates.getTaskIds().values()) {
            Bukkit.getScheduler().cancelTask(taskId);
        }
        Accelerator.rollback();
        originalTickers.clear();
        running.clear();
        tickLocations.clear();
    }

    public static void rollback() {
        for (Map.Entry<SlimefunItem, BlockTicker> entry : originalTickers.entrySet()) {
            SlimefunItem slimefunItem = entry.getKey();
            BlockTicker blockTicker = entry.getValue();
            ItemState state = slimefunItem.getState();
            ReflectionUtil.setValue(slimefunItem, SlimefunItem.class, "state", ItemState.UNREGISTERED);
            slimefunItem.addItemHandler(new ItemHandler[]{blockTicker});
            ReflectionUtil.setValue(slimefunItem, SlimefunItem.class, "state", state);
        }
        originalTickers.clear();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInit(SlimefunItemRegistryFinalizedEvent event) {
        Accelerator.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPlace(@NotNull BlockPlaceEvent event) {
        Set locations;
        if (isCNSlimefun) {
            Set locations2;
            SlimefunBlockData config = StorageCacheUtils.getBlock((Location)event.getBlock().getLocation());
            if (config == null) {
                return;
            }
            Set set = locations2 = allTickerLocations.computeIfAbsent(config.getSfId(), k -> ConcurrentHashMap.newKeySet());
            synchronized (set) {
                locations2.add(event.getBlock().getLocation());
            }
        }
        Config config = BlockStorage.getLocationInfo((Location)event.getBlock().getLocation());
        if (config == null) {
            return;
        }
        String id = config.getString("id");
        if (id == null) {
            return;
        }
        Set set = locations = allTickerLocations.computeIfAbsent(id, k -> ConcurrentHashMap.newKeySet());
        synchronized (set) {
            locations.add(event.getBlock().getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onBlockPlacerPlace(@NotNull BlockPlacerPlaceEvent event) {
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)event.getItemStack());
        if (slimefunItem != null) {
            Set locations;
            Set set = locations = allTickerLocations.computeIfAbsent(slimefunItem.getId(), k -> ConcurrentHashMap.newKeySet());
            synchronized (set) {
                locations.add(event.getBlockPlacer().getLocation());
            }
        }
    }
}

