/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.slimefunaccelerator.api.utils;

import com.balugaq.slimefunaccelerator.api.AcceleratorSettings;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import org.jetbrains.annotations.NotNull;

public final class Accelerates {
    public static final Map<String, BlockTicker> tickers = new HashMap<String, BlockTicker>();
    public static final Map<String, Integer> taskIds = new HashMap<String, Integer>();
    public static final Map<String, AcceleratorSettings> accelerateSettings = new HashMap<String, AcceleratorSettings>();
    public static final Map<String, Set<SlimefunItem>> accelerates = new HashMap<String, Set<SlimefunItem>>();

    public static void addAccelerate(String group, @NotNull Collection<String> ids) {
        for (String id : ids) {
            Accelerates.addAccelerate(group, id);
        }
    }

    public static void addAccelerate(String group, @NotNull String id) {
        SlimefunItem item = SlimefunItem.getById((String)id);
        if (!accelerates.containsKey(group)) {
            accelerates.put(group, new HashSet());
        }
        accelerates.get(group).add(item);
    }

    public static void accelerate(String group, @NotNull Collection<SlimefunItem> items) {
        if (!accelerates.containsKey(group)) {
            accelerates.put(group, new HashSet());
        }
        accelerates.get(group).addAll(items);
    }

    public static void accelerate(String group, SlimefunItem item) {
        if (!accelerates.containsKey(group)) {
            accelerates.put(group, new HashSet());
        }
        accelerates.get(group).add(item);
    }

    @NotNull
    public static Set<SlimefunItem> accelerates(String group) {
        return accelerates.get(group);
    }

    @NotNull
    public static Map<String, Set<SlimefunItem>> accelerateAll() {
        return accelerates;
    }

    public static void removeAccelerate(String group, @NotNull Collection<String> ids) {
        for (String id : ids) {
            Accelerates.removeAccelerate(group, id);
        }
    }

    public static void removeAccelerate(String group, @NotNull String id) {
        SlimefunItem item = SlimefunItem.getById((String)id);
        if (accelerates.containsKey(group)) {
            accelerates.get(group).remove(item);
        }
    }

    public static void removeAccelerate(String group) {
        accelerates.remove(group);
    }

    public static void rmAccelerate(String group, @NotNull Collection<SlimefunItem> items) {
        for (SlimefunItem item : items) {
            Accelerates.rmAccelerate(group, item);
        }
    }

    public static void rmAccelerate(String group, SlimefunItem item) {
        if (accelerates.containsKey(group)) {
            accelerates.get(group).remove(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAccelerates() {
        Map<String, AcceleratorSettings> map = accelerateSettings;
        synchronized (map) {
            accelerates.clear();
        }
    }

    public static void addAccelerateSettings(String group, boolean enabled, boolean async, int delay, int period, boolean removeOriginalTicker, boolean enabledExtraTicker, boolean tickUnload, int extraTickerDelay, int extraTickerPeriod) {
        Accelerates.addAccelerateSettings(group, new AcceleratorSettings(enabled, async, delay, period, removeOriginalTicker, enabledExtraTicker, tickUnload, extraTickerDelay, extraTickerPeriod));
    }

    public static void addAccelerateSettings(String group, AcceleratorSettings settings) {
        accelerateSettings.put(group, settings);
    }

    public static void shutdown() {
        tickers.clear();
        taskIds.clear();
        accelerateSettings.clear();
        accelerates.clear();
    }

    @Generated
    private Accelerates() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static Map<String, BlockTicker> getTickers() {
        return tickers;
    }

    @Generated
    public static Map<String, Integer> getTaskIds() {
        return taskIds;
    }

    @Generated
    public static Map<String, AcceleratorSettings> getAccelerateSettings() {
        return accelerateSettings;
    }

    @Generated
    public static Map<String, Set<SlimefunItem>> getAccelerates() {
        return accelerates;
    }
}

