/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.slimefunaccelerator.core.services;

import com.balugaq.slimefunaccelerator.api.Language;
import com.balugaq.slimefunaccelerator.implementation.SlimefunAccelerator;
import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class LocalizationService {
    private static final Set<String> FAILED_PATHS = new HashSet<String>();
    private static final Map<String, String> CACHE = new HashMap<String, String>();
    private static final String KEY_NAME = ".name";
    private static final String KEY_LORE = ".lore";
    private static final String MSG_KEY_NULL = "key cannot be null";
    private static final String MSG_ID_NULL = "id cannot be null";
    private static final String MSG_MATERIAL_NULL = "Material cannot be null";
    private static final String MSG_ITEMSTACK_NULL = "ItemStack cannot be null";
    private static final String MSG_TEXTURE_NULL = "Texture cannot be null";
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final String langFolderName;
    @NotNull
    private final File langFolder;
    @NotNull
    private final List<String> languages;
    @NotNull
    private final Map<String, Language> langMap;
    private String idPrefix = "";
    private String itemGroupKey = "categories";
    private String itemsKey = "items";
    private String recipesKey = "recipes";
    @NotNull
    private final String colorTagRegex = "<[a-zA-Z0-9_]+>";
    @NotNull
    private final Pattern pattern = Pattern.compile(this.colorTagRegex);

    @ParametersAreNonnullByDefault
    public LocalizationService(JavaPlugin plugin) {
        this(plugin, "lang");
    }

    @ParametersAreNonnullByDefault
    public LocalizationService(JavaPlugin plugin, String folderName) {
        this.languages = new LinkedList<String>();
        this.langMap = new LinkedHashMap<String, Language>();
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"The plugin instance should not be null");
        Preconditions.checkArgument((folderName != null ? 1 : 0) != 0, (Object)"The folder name should not be null");
        this.plugin = plugin;
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdir();
        }
        this.langFolderName = folderName;
        this.langFolder = new File(plugin.getDataFolder(), folderName);
        if (!this.langFolder.exists()) {
            this.langFolder.mkdir();
        }
    }

    @ParametersAreNonnullByDefault
    public LocalizationService(JavaPlugin plugin, String folderName, String langFile) {
        this(plugin, folderName);
        this.addLanguage(langFile);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public String getString(String key, Object ... args) {
        return MessageFormat.format(this.getString(key), args);
    }

    @ParametersAreNonnullByDefault
    public void sendMessage(CommandSender sender, String messageKey, Object ... args) {
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"CommandSender cannot be null");
        Preconditions.checkArgument((messageKey != null ? 1 : 0) != 0, (Object)"Message key cannot be null");
        this.send(sender, MessageFormat.format(this.getString("messages." + messageKey), args), new Object[0]);
    }

    @ParametersAreNonnullByDefault
    public void sendActionbarMessage(Player p, String messageKey, Object ... args) {
        Preconditions.checkArgument((p != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        Preconditions.checkArgument((messageKey != null ? 1 : 0) != 0, (Object)"Message key cannot be null");
        String message = MessageFormat.format(this.getString("messages." + messageKey), args);
        BaseComponent[] components = TextComponent.fromLegacyText((String)this.color(message));
        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
    }

    public final void addLanguage(@Nonnull String langFilename) {
        Preconditions.checkArgument((langFilename != null ? 1 : 0) != 0, (Object)"The language file name should not be null");
        File langFile = new File(this.langFolder, langFilename + ".yml");
        String resourcePath = this.langFolderName + "/" + langFilename + ".yml";
        if (!langFile.exists()) {
            try {
                this.plugin.saveResource(resourcePath, false);
            }
            catch (IllegalArgumentException var6) {
                this.plugin.getLogger().log(Level.SEVERE, "The default language file {0} does not exist in jar file!", resourcePath);
                return;
            }
        }
        this.languages.add(langFilename);
        InputStreamReader defaultReader = new InputStreamReader(this.plugin.getResource(resourcePath), StandardCharsets.UTF_8);
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)defaultReader);
        this.langMap.put(langFilename, new Language(langFilename, langFile, (FileConfiguration)defaultConfig));
    }

    @Nonnull
    public String getString0(@Nonnull String path) {
        String lang;
        String localization;
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path cannot be null");
        String cached = CACHE.get(path);
        if (cached != null) {
            return cached;
        }
        Iterator<String> languages = this.languages.iterator();
        do {
            if (languages.hasNext()) continue;
            if (!FAILED_PATHS.contains(path)) {
                SlimefunAccelerator.getInstance().getLogger().severe("No localization found for path: " + path);
                FAILED_PATHS.add(path);
            }
            return path;
        } while ((localization = this.langMap.get(lang = languages.next()).getLang().getString(path)) == null);
        CACHE.put(path, localization);
        return localization;
    }

    @Nonnull
    public List<String> getStringList(@Nonnull String path) {
        String lang;
        List localization;
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path cannot be null");
        Iterator<String> languages = this.languages.iterator();
        do {
            if (languages.hasNext()) continue;
            return new ArrayList<String>();
        } while ((localization = this.langMap.get(lang = languages.next()).getLang().getStringList(path)).isEmpty());
        for (int i = 0; i < localization.size(); ++i) {
            localization.set(i, this.color((String)localization.get(i)));
        }
        return localization;
    }

    @Nonnull
    public String[] getStringArray(@Nonnull String path) {
        return this.getStringList(path).stream().map(this::color).toList().toArray(new String[0]);
    }

    @NotNull
    protected JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Nonnull
    public String getString(@Nonnull String path) {
        return this.color(this.getString0(path));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemBy(String key, String id, Material material, String ... extraLore) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)MSG_KEY_NULL);
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)MSG_ID_NULL);
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)MSG_MATERIAL_NULL);
        SlimefunItemStack item = new SlimefunItemStack((this.idPrefix + id).toUpperCase(Locale.ROOT), material, this.getString(key + "." + id + KEY_NAME), this.getStringArray(key + "." + id + KEY_LORE));
        if (extraLore != null && extraLore.length != 0) {
            this.appendLore(item, extraLore);
        }
        return item;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemBy(String key, String id, String texture, String ... extraLore) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)MSG_KEY_NULL);
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)MSG_ID_NULL);
        Preconditions.checkArgument((texture != null ? 1 : 0) != 0, (Object)MSG_TEXTURE_NULL);
        return this.appendLore(new SlimefunItemStack((this.idPrefix + id).toUpperCase(Locale.ROOT), texture, this.getString(key + "." + id + KEY_NAME), this.getStringArray(key + "." + id + KEY_LORE)), extraLore);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemBy(String key, String id, ItemStack itemStack, String ... extraLore) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)MSG_KEY_NULL);
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)MSG_ID_NULL);
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)MSG_ITEMSTACK_NULL);
        return this.appendLore(new SlimefunItemStack((this.idPrefix + id).toUpperCase(Locale.ROOT), itemStack, this.getString(key + "." + id + KEY_NAME), this.getStringArray(key + "." + id + KEY_LORE)), extraLore);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemGroupItem(String id, Material material) {
        return this.getItemBy(this.itemGroupKey, id, material, new String[0]);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemGroupItem(String id, String texture) {
        return this.getItemBy(this.itemGroupKey, id, texture, new String[0]);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItemGroupItem(String id, ItemStack itemStack) {
        return this.getItemBy(this.itemGroupKey, id, itemStack, new String[0]);
    }

    @NotNull
    public SlimefunItemStack getItem(@NotNull String id, @NotNull Material material, String ... extraLore) {
        return this.getItemBy(this.itemsKey, id, material, extraLore);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItem(String id, String texture, String ... extraLore) {
        return this.getItemBy(this.itemsKey, id, texture, extraLore);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public SlimefunItemStack getItem(String id, ItemStack itemStack, String ... extraLore) {
        return this.getItemBy(this.itemsKey, id, itemStack, extraLore);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public RecipeType getRecipeType(String id, Material material, String ... extraLore) {
        return new RecipeType(new NamespacedKey((Plugin)this.getPlugin(), id), (ItemStack)this.getItemBy(this.recipesKey, id, material, extraLore));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public RecipeType getRecipeType(String id, String texture, String ... extraLore) {
        return new RecipeType(new NamespacedKey((Plugin)this.getPlugin(), id), (ItemStack)this.getItemBy(this.recipesKey, id, texture, extraLore));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public RecipeType getRecipeType(String id, ItemStack itemStack, String ... extraLore) {
        return new RecipeType(new NamespacedKey((Plugin)this.getPlugin(), id), (ItemStack)this.getItemBy(this.recipesKey, id, itemStack, extraLore));
    }

    public void setIdPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
    }

    public void setItemGroupKey(String itemGroupKey) {
        this.itemGroupKey = itemGroupKey;
    }

    public void setItemsKey(String itemsKey) {
        this.itemsKey = itemsKey;
    }

    public void setRecipesKey(String recipesKey) {
        this.recipesKey = recipesKey;
    }

    @NotNull
    private <T extends ItemStack> T appendLore(@Nonnull T itemStack, String ... extraLore) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)MSG_ITEMSTACK_NULL);
        if (extraLore != null && extraLore.length != 0) {
            ItemMeta meta = itemStack.getItemMeta();
            List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
            lore.addAll(this.color(Arrays.asList(extraLore)));
            meta.setLore(lore);
            itemStack.setItemMeta(meta);
            return itemStack;
        }
        return itemStack;
    }

    @Nonnull
    public String color(@Nonnull String str) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)str);
    }

    @Nonnull
    public List<String> color(@Nonnull List<String> strList) {
        Preconditions.checkArgument((strList != null ? 1 : 0) != 0, (Object)"String list cannot be null");
        return strList.stream().map(this::color).collect(Collectors.toList());
    }

    @ParametersAreNonnullByDefault
    public void send(CommandSender sender, String message, Object ... args) {
        sender.sendMessage(this.color(MessageFormat.format(message, args)));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ItemStack getItemStack(String key, Material material) {
        return new CustomItemStack(material, this.getString(key + KEY_NAME), this.getStringArray(key + KEY_LORE));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ItemStack getIcon(String key, Material material) {
        return this.getItemStack("icons." + key, material);
    }

    @Generated
    public String getIdPrefix() {
        return this.idPrefix;
    }
}

