/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.slimefunaccelerator.implementation;

import com.balugaq.slimefunaccelerator.api.utils.Accelerates;
import com.balugaq.slimefunaccelerator.api.utils.Lang;
import com.balugaq.slimefunaccelerator.core.listeners.Accelerator;
import com.balugaq.slimefunaccelerator.core.managers.CommandManager;
import com.balugaq.slimefunaccelerator.core.managers.ConfigManager;
import com.balugaq.slimefunaccelerator.core.managers.IntegrationManager;
import com.balugaq.slimefunaccelerator.core.managers.ListenerManager;
import com.balugaq.slimefunaccelerator.core.services.LocalizationService;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import java.io.File;
import lombok.Generated;
import net.guizhanss.guizhanlibplugin.updater.GuizhanUpdater;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlimefunAccelerator
extends JavaPlugin
implements SlimefunAddon {
    private static final String DEFAULT_LANGUAGE = "zh-CN";
    private static boolean enabledPlugin = false;
    private static SlimefunAccelerator instance;
    private final String username = "balugaq";
    private final String repo = "SlimefunAccelerator";
    private final String branch = "master";
    private ConfigManager configManager;
    private CommandManager commandManager;
    private IntegrationManager integrationManager;
    private ListenerManager listenerManager;
    private LocalizationService localizationService;

    public void onEnable() {
        instance = this;
        enabledPlugin = true;
        this.getLogger().info("Enabling SlimefunAccelerator...");
        this.getLogger().info("Loading configuration...");
        this.configManager = new ConfigManager(this);
        this.getLogger().info("Loading localization...");
        this.localizationService = new LocalizationService(this);
        this.getLogger().info("Loading language: " + this.getConfigManager().getLanguage());
        this.localizationService.addLanguage(this.getConfigManager().getLanguage());
        this.getLogger().info("Loading default language... (zh-CN)");
        this.localizationService.addLanguage(DEFAULT_LANGUAGE);
        this.getLogger().info("Loading integrations...");
        this.integrationManager = new IntegrationManager(this);
        this.getLogger().info("Loading commands...");
        this.commandManager = new CommandManager(this);
        this.commandManager.setup();
        this.commandManager.registerCommand();
        this.getLogger().info("Loading listeners...");
        this.listenerManager = new ListenerManager(this);
        this.getListenerManager().setup();
        this.getListenerManager().load();
        this.getLogger().info("Checking for updates...");
        switch (this.getConfigManager().getBuildStation()) {
            case GUIZHAN: {
                if (this.getIntegrationManager().isEnabledGuizhanLibPlugin()) {
                    this.getLogger().info("Auto-updating from Guizhan Build...");
                    this.tryUpdateFromGuizhan();
                    break;
                }
                this.getLogger().severe("GuizhanLibPlugin required for auto-update!");
                this.getLogger().severe("Download from: https://50l.cc/gzlib");
                break;
            }
            case BLOB: {
                this.getLogger().info("Auto-updating from Blob Build...");
                this.tryUpdateFromBlob();
                break;
            }
            default: {
                this.getLogger().severe("Unknown build station: " + String.valueOf((Object)this.getConfigManager().getBuildStation()));
            }
        }
    }

    public boolean tryUpdateFromGuizhan() {
        try {
            if (SlimefunAccelerator.getInstance().getConfigManager().isAutoUpdate() && this.getDescription().getVersion().startsWith("Build")) {
                GuizhanUpdater.start((Plugin)this, (File)this.getFile(), (String)SlimefunAccelerator.getInstance().getUsername(), (String)SlimefunAccelerator.getInstance().getRepo(), (String)SlimefunAccelerator.getInstance().getBranch());
                return true;
            }
        }
        catch (NoClassDefFoundError | NullPointerException | UnsupportedClassVersionError e) {
            this.getLogger().info(Lang.getMessage("load.failed-auto-update", "message", e.getMessage()));
            e.printStackTrace();
        }
        return false;
    }

    public boolean tryUpdateFromBlob() {
        if (this.getConfigManager().isAutoUpdate() && this.getDescription().getVersion().startsWith("DEV - ")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), SlimefunAccelerator.getInstance().getRepo(), "Dev").start();
            return true;
        }
        return false;
    }

    public void onDisable() {
        enabledPlugin = false;
        this.getLogger().info("Disabling SlimefunAccelerator...");
        this.getLogger().info("Unloading listeners...");
        Accelerator.shutdown();
        Accelerates.shutdown();
        this.getListenerManager().unload();
        this.getLogger().info("SlimefunAccelerator disabled.");
    }

    @NotNull
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    @Nullable
    public String getBugTrackerURL() {
        return "https://github.com/balugaq/SlimefunAccelerator/issues";
    }

    @Generated
    public static String getDEFAULT_LANGUAGE() {
        return DEFAULT_LANGUAGE;
    }

    @Generated
    public static boolean isEnabledPlugin() {
        return enabledPlugin;
    }

    @Generated
    public static SlimefunAccelerator getInstance() {
        return instance;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getRepo() {
        return this.repo;
    }

    @Generated
    public String getBranch() {
        return this.branch;
    }

    @Generated
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    @Generated
    public IntegrationManager getIntegrationManager() {
        return this.integrationManager;
    }

    @Generated
    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    @Generated
    public LocalizationService getLocalizationService() {
        return this.localizationService;
    }
}

