/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.slimefunaccelerator.core.managers;

import com.balugaq.slimefunaccelerator.api.utils.Lang;
import com.balugaq.slimefunaccelerator.core.commands.SubCommand;
import com.balugaq.slimefunaccelerator.core.commands.subcommands.HelpCommand;
import com.balugaq.slimefunaccelerator.core.commands.subcommands.IdCommand;
import com.balugaq.slimefunaccelerator.core.commands.subcommands.ReloadCommand;
import com.balugaq.slimefunaccelerator.core.commands.subcommands.VersionCommand;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManager
implements TabExecutor {
    private static final String ROOT_COMMAND = "slimefunaccelerator";
    @NotNull
    private final JavaPlugin plugin;
    private final List<SubCommand> subCommands = new ArrayList<SubCommand>();
    @NotNull
    private final SubCommand defaultCommand;

    public CommandManager(@NotNull JavaPlugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin cannot be null");
        this.plugin = plugin;
        this.defaultCommand = new HelpCommand(plugin);
        this.setup();
        this.registerCommand();
    }

    public void setup() {
        this.subCommands.add(new HelpCommand(this.plugin));
        this.subCommands.add(new ReloadCommand(this.plugin));
        this.subCommands.add(new VersionCommand(this.plugin));
        this.subCommands.add(new IdCommand(this.plugin));
    }

    public void registerCommand() {
        PluginCommand command = this.plugin.getCommand(ROOT_COMMAND);
        if (command == null) {
            this.plugin.getLogger().severe("Command \"slimefunaccelerator\" not found!");
            return;
        }
        command.setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.isOp()) {
            sender.sendMessage(Lang.getMessage("commands.no-permission"));
            return true;
        }
        for (SubCommand subCommand : this.subCommands) {
            if (!subCommand.canCommand(sender, command, label, args)) continue;
            subCommand.onCommand(sender, command, label, args);
            return true;
        }
        return this.defaultCommand.onCommand(sender, command, label, args);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        List<String> subCommandNames = this.subCommands.stream().map(SubCommand::getName).toList();
        if (args.length <= 1) {
            return subCommandNames;
        }
        ArrayList<String> completions = new ArrayList<String>();
        for (SubCommand subCommand : this.subCommands) {
            List<String> subCompletion = subCommand.onTabComplete(sender, command, label, args);
            if (subCompletion == null) continue;
            completions.addAll(subCompletion);
        }
        return completions;
    }

    @NotNull
    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public List<SubCommand> getSubCommands() {
        return this.subCommands;
    }

    @NotNull
    @Generated
    public SubCommand getDefaultCommand() {
        return this.defaultCommand;
    }
}

