/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils.holograms;

import io.github.thebusybiscuit.slimefun4.utils.holograms.SimpleHologram;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;

public final class HologramProjectorHologram {
    private HologramProjectorHologram() {
    }

    public static ArmorStand getArmorStand(Block projector, boolean createIfNoneExists) {
        String nametag = BlockStorage.getLocationInfo(projector.getLocation(), "text");
        double offset = Double.parseDouble(BlockStorage.getLocationInfo(projector.getLocation(), "offset"));
        Location l = new Location(projector.getWorld(), (double)projector.getX() + 0.5, (double)projector.getY() + offset, (double)projector.getZ() + 0.5);
        for (Entity n : l.getChunk().getEntities()) {
            if (!(n instanceof ArmorStand) || n.getCustomName() == null || !n.getCustomName().equals(nametag) || !(l.distanceSquared(n.getLocation()) < 0.4)) continue;
            return (ArmorStand)n;
        }
        if (!createIfNoneExists) {
            return null;
        }
        ArmorStand hologram = SimpleHologram.create(l);
        hologram.setCustomName(nametag);
        return hologram;
    }

    public static void remove(Block b) {
        ArmorStand hologram = HologramProjectorHologram.getArmorStand(b, false);
        if (hologram != null) {
            hologram.remove();
        }
    }
}

