/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.debugging;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import lombok.NonNull;

public class MemoryDump {
    private Predicate<String> namespaces;
    private final Map<String, Integer> heatmap = new HashMap<String, Integer>();
    private final Set<Integer> hashes = new HashSet<Integer>();

    public MemoryDump(@NonNull String file, @NonNull String namespace, Object ... objects) throws FileNotFoundException {
        this(file, (String str) -> str.startsWith(namespace), objects);
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryDump(@NonNull String file, @NonNull Predicate<String> includeNamespaces, Object ... objects) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (includeNamespaces == null) {
            throw new NullPointerException("includeNamespaces is marked non-null but is null");
        }
        this.namespaces = includeNamespaces;
        if (objects.length == 0) {
            throw new IllegalArgumentException("You need to provide at least one Object!");
        }
        try (PrintStream stream = new PrintStream(file);){
            for (Object obj : objects) {
                this.dump(stream, "", "", obj);
            }
            stream.println();
            stream.println();
            stream.println("---- Heatmap ----");
            this.heatmap.entrySet().stream().sorted((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue())).forEach(entry -> stream.println(entry.getValue() + "x " + (String)entry.getKey()));
        }
        finally {
            this.hashes.clear();
        }
    }

    private void dump(@NonNull PrintStream stream, @NonNull String prefix, @NonNull String name, Object obj) {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (obj == null) {
            stream.println(prefix + "null");
        } else if (this.hashes.add(obj.hashCode())) {
            try {
                this.heatmap.merge(obj.getClass().getName(), 1, Integer::sum);
                stream.println(prefix + name + ": [" + obj.hashCode() + "] " + obj.getClass().getName() + " : " + obj.toString());
                if (obj instanceof Collection) {
                    if (!((Collection)obj).isEmpty()) {
                        AtomicInteger integer = new AtomicInteger(0);
                        ((Collection)obj).iterator().forEachRemaining(item -> this.dump(stream, prefix + " ", String.valueOf(integer.incrementAndGet()), item));
                    }
                } else if (obj instanceof Map) {
                    if (!((Map)obj).isEmpty()) {
                        ((Map)obj).entrySet().forEach(entry -> this.dump(stream, prefix + " ", entry.getKey() + "", entry.getValue()));
                    }
                } else if (this.namespaces.test(obj.getClass().getName())) {
                    for (Field field : obj.getClass().getDeclaredFields()) {
                        field.setAccessible(true);
                        try {
                            this.dump(stream, prefix + "  ", field.getName(), field.get(obj));
                        }
                        catch (IllegalAccessException | IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (NoClassDefFoundError x) {
                System.err.println(x.getClass().getSimpleName() + ": " + x.getMessage());
            }
        }
    }

    public Predicate<String> getNamespaces() {
        return this.namespaces;
    }

    public Map<String, Integer> getHeatmap() {
        return this.heatmap;
    }
}

