/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.magical;

import java.util.List;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SimpleSlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemUseHandler;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class StormStaff
extends SimpleSlimefunItem<ItemUseHandler> {
    public static final int MAX_USES = 8;
    private static final NamespacedKey usageKey = new NamespacedKey((Plugin)SlimefunPlugin.instance, "stormstaff_usage");

    public StormStaff(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe, StormStaff.getCraftedOutput());
    }

    private static ItemStack getCraftedOutput() {
        ItemStack item = SlimefunItems.STAFF_STORM.clone();
        ItemMeta im = item.getItemMeta();
        List lore = im.getLore();
        lore.set(4, ChatColor.translateAlternateColorCodes((char)'&', (String)"&e8 Uses &7left"));
        im.setLore(lore);
        item.setItemMeta(im);
        return item;
    }

    @Override
    public ItemUseHandler getItemHandler() {
        return e -> {
            Player p = e.getPlayer();
            ItemStack item = e.getItem();
            if (!item.hasItemMeta()) {
                return;
            }
            ItemMeta itemMeta = item.getItemMeta();
            if (!itemMeta.hasLore()) {
                return;
            }
            List itemLore = itemMeta.getLore();
            ItemStack sfItem = this.getItem();
            ItemMeta sfItemMeta = sfItem.getItemMeta();
            List sfItemLore = sfItemMeta.getLore();
            if (itemLore.size() < 6 && ((String)itemLore.get(1)).equals(sfItemLore.get(1)) && ((String)itemLore.get(3)).equals(sfItemLore.get(3))) {
                if (p.getFoodLevel() >= 4 || p.getGameMode() == GameMode.CREATIVE) {
                    Location loc = p.getTargetBlock(null, 30).getLocation();
                    if (loc.getWorld() != null && loc.getChunk().isLoaded()) {
                        if (loc.getWorld().getPVP() && SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, loc, ProtectableAction.PVP)) {
                            loc.getWorld().strikeLightning(loc);
                            if (p.getInventory().getItemInMainHand().getType() != Material.SHEARS && p.getGameMode() != GameMode.CREATIVE) {
                                FoodLevelChangeEvent event = new FoodLevelChangeEvent((HumanEntity)p, p.getFoodLevel() - 4);
                                Bukkit.getPluginManager().callEvent((Event)event);
                                p.setFoodLevel(event.getFoodLevel());
                            }
                            int currentUses = (Integer)itemMeta.getPersistentDataContainer().getOrDefault(usageKey, PersistentDataType.INTEGER, (Object)8);
                            e.cancel();
                            if (currentUses == 1) {
                                p.playSound(p.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                                item.setAmount(0);
                            } else {
                                itemMeta.getPersistentDataContainer().set(usageKey, PersistentDataType.INTEGER, (Object)(--currentUses));
                                itemLore.set(4, ChatColor.translateAlternateColorCodes((char)'&', (String)("&e" + currentUses + ' ' + (currentUses > 1 ? "Uses" : "Use") + " &7left")));
                                itemMeta.setLore(itemLore);
                                item.setItemMeta(itemMeta);
                            }
                            return;
                        }
                        SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.no-pvp", true);
                    }
                } else {
                    SlimefunPlugin.getLocal().sendMessage((CommandSender)p, "messages.hungry", true);
                }
                return;
            }
        };
    }
}

