/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.skull;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.reflection.ReflectionUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.FakeProfile;
import org.bukkit.Material;
import org.bukkit.block.Block;

public final class SkullBlock {
    private static Constructor<?> newPosition;
    private static Method handle;
    private static Method getTileEntity;
    private static Method setGameProfile;

    private SkullBlock() {
    }

    public static void setFromBase64(@NonNull Block block, @NonNull String texture) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
        SkullBlock.setFromBase64(block, UUID.nameUUIDFromBytes(texture.getBytes()), texture);
    }

    public static void setFromBase64(@NonNull Block block, @NonNull UUID uuid, @NonNull String texture) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
        if (!block.getType().equals((Object)Material.PLAYER_HEAD) && !block.getType().equals((Object)Material.PLAYER_WALL_HEAD)) {
            throw new IllegalArgumentException("Block is not a Skull");
        }
        try {
            Object profile = FakeProfile.createProfile(uuid, texture);
            Object world = handle.invoke((Object)block.getWorld(), new Object[0]);
            Object position = newPosition.newInstance(block.getX(), block.getY(), block.getZ());
            Object tileEntity = getTileEntity.invoke(world, position);
            if (tileEntity != null) {
                setGameProfile.invoke(tileEntity, profile);
                block.getState().update(true);
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            handle = ReflectionUtils.getOBCClass("CraftWorld").getMethod("getHandle", new Class[0]);
            setGameProfile = ReflectionUtils.getNMSClass("TileEntitySkull").getMethod("setGameProfile", FakeProfile.profileClass);
            Class<?> blockPosition = ReflectionUtils.getNMSClass("BlockPosition");
            newPosition = ReflectionUtils.getConstructor(blockPosition, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            getTileEntity = ReflectionUtils.getNMSClass("WorldServer").getMethod("getTileEntity", blockPosition);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            System.err.println("Perhaps you forgot to shade CS-CoreLib's \"reflection\" package?");
            e.printStackTrace();
        }
    }
}

