/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.chat;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatInput;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.IChatInput;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;

class ChatInputListener
implements Listener {
    private Plugin plugin;
    protected Map<UUID, Set<IChatInput>> handlers;

    protected ChatInputListener(Plugin plugin) {
        this.plugin = plugin;
        this.handlers = new HashMap<UUID, Set<IChatInput>>();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    public void addCallback(UUID uuid, IChatInput input) {
        Set callbacks = this.handlers.computeIfAbsent(uuid, id -> new HashSet());
        callbacks.add(input);
    }

    @EventHandler
    public void onDisable(PluginDisableEvent e) {
        if (e.getPlugin() == this.plugin) {
            ChatInput.listener = null;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChat(AsyncPlayerChatEvent e) {
        String msg = e.getMessage().replace('\u00a7', '&');
        this.checkInput((Cancellable)e, e.getPlayer(), msg);
    }

    @EventHandler
    public void onComamnd(PlayerCommandPreprocessEvent e) {
        this.checkInput((Cancellable)e, e.getPlayer(), e.getMessage());
    }

    private void checkInput(Cancellable e, Player p, String msg) {
        Set<IChatInput> callbacks = this.handlers.get(p.getUniqueId());
        if (callbacks != null) {
            Iterator<IChatInput> iterator = callbacks.iterator();
            while (iterator.hasNext()) {
                IChatInput handler = iterator.next();
                if (handler.isExpired()) {
                    iterator.remove();
                    continue;
                }
                if (!handler.test(msg)) continue;
                iterator.remove();
                this.plugin.getServer().getScheduler().runTask(this.plugin, () -> handler.onChat(p, msg));
                e.setCancelled(true);
                return;
            }
            if (callbacks.isEmpty()) {
                this.handlers.remove(p.getUniqueId());
            }
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        this.handlers.remove(e.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onKick(PlayerKickEvent e) {
        this.handlers.remove(e.getPlayer().getUniqueId());
    }
}

