/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.materials;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialCollections;
import org.bukkit.Material;

public final class MaterialConverter {
    private MaterialConverter() {
    }

    public static Optional<Material> getSaplingFromLog(@NonNull Material log) {
        if (log == null) {
            throw new NullPointerException("log is marked non-null but is null");
        }
        return MaterialConverter.convert(log, MaterialCollections.getAllLogs()::contains, type -> type.substring(0, type.lastIndexOf(95)).replace("STRIPPED_", "") + "_SAPLING");
    }

    public static Optional<Material> getSaplingFromLeaves(@NonNull Material leaves) {
        if (leaves == null) {
            throw new NullPointerException("leaves is marked non-null but is null");
        }
        return MaterialConverter.convert(leaves, MaterialCollections.getAllLeaves()::contains, type -> type.replace("_LEAVES", "_SAPLING"));
    }

    public static Optional<Material> getPlanksFromLog(@NonNull Material log) {
        if (log == null) {
            throw new NullPointerException("log is marked non-null but is null");
        }
        return MaterialConverter.convert(log, MaterialCollections.getAllLogs()::contains, type -> type.substring(0, type.lastIndexOf(95)).replace("STRIPPED_", "") + "_PLANKS");
    }

    public static Optional<Material> getStrippedFromLog(@NonNull Material log) {
        if (log == null) {
            throw new NullPointerException("log is marked non-null but is null");
        }
        return MaterialConverter.convert(log, type -> MaterialCollections.getAllLogs().contains((Material)type) && !type.name().startsWith("STRIPPED_"), type -> "STRIPPED_" + type);
    }

    public static Optional<Material> getGlassFromPane(@NonNull Material pane) {
        if (pane == null) {
            throw new NullPointerException("pane is marked non-null but is null");
        }
        return MaterialConverter.convert(pane, MaterialCollections.getAllStainedGlassPaneColors()::contains, type -> type.substring(0, type.length() - "_PANE".length()));
    }

    public static Optional<Material> getPaneFromGlass(@NonNull Material glass) {
        if (glass == null) {
            throw new NullPointerException("glass is marked non-null but is null");
        }
        return MaterialConverter.convert(glass, MaterialCollections.getAllStainedGlassColors()::contains, type -> type + "_PANE");
    }

    public static Optional<Material> getWoolFromDye(@NonNull Material dye) {
        if (dye == null) {
            throw new NullPointerException("dye is marked non-null but is null");
        }
        return MaterialConverter.convert(dye, MaterialCollections.getAllDyeColors()::contains, type -> type.replace("_DYE", "_WOOL"));
    }

    public static Optional<Material> getCarpetFromDye(@NonNull Material dye) {
        if (dye == null) {
            throw new NullPointerException("dye is marked non-null but is null");
        }
        return MaterialConverter.convert(dye, MaterialCollections.getAllDyeColors()::contains, type -> type.replace("_DYE", "_CARPET"));
    }

    public static Optional<Material> getStainedGlassFromDye(@NonNull Material dye) {
        if (dye == null) {
            throw new NullPointerException("dye is marked non-null but is null");
        }
        return MaterialConverter.convert(dye, MaterialCollections.getAllDyeColors()::contains, type -> type.replace("_DYE", "_STAINED_GLASS"));
    }

    public static Optional<Material> getStainedGlassPaneFromDye(@NonNull Material dye) {
        if (dye == null) {
            throw new NullPointerException("dye is marked non-null but is null");
        }
        return MaterialConverter.convert(dye, MaterialCollections.getAllDyeColors()::contains, type -> type.replace("_DYE", "_STAINED_GLASS_PANE"));
    }

    private static Optional<Material> convert(Material type, Predicate<Material> predicate, UnaryOperator<String> converter) {
        if (!predicate.test(type)) {
            return Optional.empty();
        }
        return Optional.ofNullable(Material.getMaterial((String)((String)converter.apply(type.name()))));
    }
}

