/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.mrCookieSlime.Slimefun.cscorelib2.database.Database;
import me.mrCookieSlime.Slimefun.cscorelib2.database.DatabaseQuery;
import org.bukkit.plugin.Plugin;

public abstract class SQLDatabase<T extends SQLDatabase<T>>
implements Database {
    protected Connection connection;
    protected Database.DatabaseLoader<T> callback;
    protected Set<DatabaseQuery.ImportantDatabaseQuery> queries;
    protected String tablePrefix = "";
    protected Plugin plugin;

    protected SQLDatabase(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    @Override
    public void addSetupQuery(String sql) {
        DatabaseQuery.ImportantDatabaseQuery query = new DatabaseQuery.ImportantDatabaseQuery(this, sql);
        this.queries.add(query);
        query.execute();
    }

    @Override
    public String getTable(String table) {
        return this.tablePrefix + table;
    }

    @Override
    public boolean isConnected() {
        try {
            if (this.connection != null && this.connection.isValid(1)) {
                for (DatabaseQuery.ImportantDatabaseQuery query : this.queries) {
                    if (query.hasFinished()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            this.getLogger().log(Level.SEVERE, "An Exeption occured while connecting to a Database", e);
            return false;
        }
    }

    @Override
    public void closeConnection() throws SQLException {
        if (!this.isConnected()) {
            return;
        }
        this.connection.close();
        this.connection = null;
    }

    @Override
    public void update(String query) {
        try (PreparedStatement statement = this.getConnection().prepareStatement(query);){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.getLogger().log(Level.SEVERE, "An Exeption occured while sending an update-query: " + query, e);
        }
    }

    @Override
    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }
}

