/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.energy;

import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullBlock;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public final class ChargableBlock {
    private ChargableBlock() {
    }

    public static void registerChargableBlock(String id, int capacity) {
        SlimefunPlugin.getRegistry().getEnergyCapacities().put(id, capacity);
        SlimefunPlugin.getRegistry().getChargeableBlocks().add(id);
    }

    public static void registerCapacitor(String id, int capacity) {
        SlimefunPlugin.getRegistry().getEnergyCapacities().put(id, capacity);
        SlimefunPlugin.getRegistry().getEnergyCapacitors().add(id);
    }

    public static boolean isChargable(Block b) {
        return ChargableBlock.isChargable(b.getLocation());
    }

    public static boolean isChargable(Location l) {
        if (!BlockStorage.hasBlockInfo(l)) {
            return false;
        }
        return SlimefunPlugin.getRegistry().getEnergyCapacities().containsKey(BlockStorage.checkID(l));
    }

    public static boolean isRechargable(Block b) {
        if (!BlockStorage.hasBlockInfo(b)) {
            return false;
        }
        String id = BlockStorage.checkID(b);
        return SlimefunPlugin.getRegistry().getEnergyCapacities().containsKey(id) && SlimefunPlugin.getRegistry().getChargeableBlocks().contains(id);
    }

    public static boolean isCapacitor(Block b) {
        return ChargableBlock.isCapacitor(b.getLocation());
    }

    public static boolean isCapacitor(Location l) {
        if (!BlockStorage.hasBlockInfo(l)) {
            return false;
        }
        return SlimefunPlugin.getRegistry().getEnergyCapacitors().contains(BlockStorage.checkID(l));
    }

    public static int getDefaultCapacity(Block b) {
        return ChargableBlock.getDefaultCapacity(b.getLocation());
    }

    public static int getDefaultCapacity(Location l) {
        String id = BlockStorage.checkID(l);
        return id == null ? 0 : SlimefunPlugin.getRegistry().getEnergyCapacities().get(id);
    }

    public static int getCharge(Block b) {
        return ChargableBlock.getCharge(b.getLocation());
    }

    public static int getCharge(Location l) {
        String charge = BlockStorage.getLocationInfo(l, "energy-charge");
        if (charge != null) {
            return Integer.parseInt(charge);
        }
        BlockStorage.addBlockInfo(l, "energy-charge", "0", false);
        return 0;
    }

    public static void setCharge(Block b, int charge) {
        ChargableBlock.setCharge(b.getLocation(), charge);
    }

    public static void setCharge(Location l, int charge) {
        if (charge < 0) {
            charge = 0;
        } else {
            int capacity = ChargableBlock.getMaxCharge(l);
            if (charge > capacity) {
                charge = capacity;
            }
        }
        if (charge != ChargableBlock.getCharge(l)) {
            BlockStorage.addBlockInfo(l, "energy-charge", String.valueOf(charge), false);
        }
    }

    public static void setUnsafeCharge(Location l, int charge, boolean updateTexture) {
        if (charge != ChargableBlock.getCharge(l)) {
            BlockStorage.addBlockInfo(l, "energy-charge", String.valueOf(charge), false);
            if (updateTexture) {
                ChargableBlock.updateTexture(l);
            }
        }
    }

    private static void updateTexture(Location l) {
        Slimefun.runSync(() -> {
            Block b = l.getBlock();
            int charge = ChargableBlock.getCharge(b);
            int capacity = ChargableBlock.getMaxCharge(b);
            if (b.getType() == Material.PLAYER_HEAD || b.getType() == Material.PLAYER_WALL_HEAD) {
                if (charge < (int)((double)capacity * 0.25)) {
                    SkullBlock.setFromBase64(b, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTEzNjFlNTc2YjQ5M2NiZmRmYWUzMjg2NjFjZWRkMWFkZDU1ZmFiNGU1ZWI0MThiOTJjZWJmNjI3NWY4YmI0In19fQ==");
                } else if (charge < (int)((double)capacity * 0.5)) {
                    SkullBlock.setFromBase64(b, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzA1MzIzMzk0YTdkOTFiZmIzM2RmMDZkOTJiNjNjYjQxNGVmODBmMDU0ZDA0NzM0ZWEwMTVhMjNjNTM5In19fQ==");
                } else if (charge < (int)((double)capacity * 0.75)) {
                    SkullBlock.setFromBase64(b, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNTU4NDQzMmFmNmYzODIxNjcxMjAyNThkMWVlZThjODdjNmU3NWQ5ZTQ3OWU3YjBkNGM3YjZhZDQ4Y2ZlZWYifX19");
                } else {
                    SkullBlock.setFromBase64(b, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvN2EyNTY5NDE1YzE0ZTMxYzk4ZWM5OTNhMmY5OWU2ZDY0ODQ2ZGIzNjdhMTNiMTk5OTY1YWQ5OWM0MzhjODZjIn19fQ==");
                }
            }
        });
    }

    public static String formatEnergy(Block b) {
        return DoubleHandler.getFancyDouble(ChargableBlock.getCharge(b)) + " J";
    }

    public static int addCharge(Block b, int charge) {
        return ChargableBlock.addCharge(b.getLocation(), charge);
    }

    public static int addCharge(Location l, int charge) {
        int energy = ChargableBlock.getCharge(l);
        int space = ChargableBlock.getMaxCharge(l) - energy;
        int rest = charge;
        if (space > 0 && charge > 0) {
            if (space > charge) {
                ChargableBlock.setCharge(l, energy + charge);
                rest = 0;
            } else {
                rest = charge - space;
                ChargableBlock.setCharge(l, ChargableBlock.getMaxCharge(l));
            }
            if (SlimefunPlugin.getRegistry().getEnergyCapacitors().contains(BlockStorage.checkID(l))) {
                ChargableBlock.updateTexture(l);
            }
        } else if (charge < 0 && energy >= -charge) {
            ChargableBlock.setCharge(l, energy + charge);
            if (SlimefunPlugin.getRegistry().getEnergyCapacitors().contains(BlockStorage.checkID(l))) {
                ChargableBlock.updateTexture(l);
            }
        }
        return rest;
    }

    public static int getMaxCharge(Block b) {
        return ChargableBlock.getMaxCharge(b.getLocation());
    }

    public static int getMaxCharge(Location l) {
        Config cfg = BlockStorage.getLocationInfo(l);
        if (!cfg.contains("id")) {
            BlockStorage.clearBlockInfo(l);
            return 0;
        }
        if (cfg.contains("energy-capacity")) {
            return Integer.parseInt(cfg.getString("energy-capacity"));
        }
        BlockStorage.addBlockInfo(l, "energy-capacity", String.valueOf(ChargableBlock.getDefaultCapacity(l)), false);
        return ChargableBlock.getDefaultCapacity(l);
    }
}

