/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.network;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import me.mrCookieSlime.CSCoreLibPlugin.general.Particles.MC_1_13.ParticleEffect;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.network.NetworkComponent;
import org.bukkit.Location;

public abstract class Network {
    private static List<Network> networkList = new ArrayList<Network>();
    protected Location regulator;
    private Queue<Location> nodeQueue = new ArrayDeque<Location>();
    protected Set<Location> connectedLocations = new HashSet<Location>();
    protected Set<Location> regulatorNodes = new HashSet<Location>();
    protected Set<Location> connectorNodes = new HashSet<Location>();
    protected Set<Location> terminusNodes = new HashSet<Location>();

    public static <T extends Network> T getNetworkFromLocation(Location l, Class<T> type) {
        for (Network network : networkList) {
            if (!type.isInstance(network) || !network.connectsTo(l)) continue;
            return (T)((Network)type.cast(network));
        }
        return null;
    }

    public static <T extends Network> List<T> getNetworksFromLocation(Location l, Class<T> type) {
        ArrayList<T> list = new ArrayList<T>();
        for (Network network : networkList) {
            if (!type.isInstance(network) || !network.connectsTo(l)) continue;
            list.add(type.cast(network));
        }
        return list;
    }

    public static void registerNetwork(Network n) {
        networkList.add(n);
    }

    public static void unregisterNetwork(Network n) {
        networkList.remove(n);
    }

    public static void handleAllNetworkLocationUpdate(Location l) {
        for (Network n : Network.getNetworksFromLocation(l, Network.class)) {
            n.handleLocationUpdate(l);
        }
    }

    public abstract int getRange();

    public abstract NetworkComponent classifyLocation(Location var1);

    public abstract void locationClassificationChange(Location var1, NetworkComponent var2, NetworkComponent var3);

    protected Network(Location regulator) {
        this.regulator = regulator;
        this.connectedLocations.add(regulator);
        this.nodeQueue.add(regulator.clone());
    }

    protected void addLocationToNetwork(Location l) {
        if (this.connectedLocations.contains(l)) {
            return;
        }
        this.connectedLocations.add(l.clone());
        this.handleLocationUpdate(l);
    }

    public void handleLocationUpdate(Location l) {
        if (this.regulator.equals((Object)l)) {
            Network.unregisterNetwork(this);
            return;
        }
        this.nodeQueue.add(l.clone());
    }

    public boolean connectsTo(Location l) {
        return this.connectedLocations.contains(l);
    }

    private NetworkComponent getCurrentClassification(Location l) {
        if (this.regulatorNodes.contains(l)) {
            return NetworkComponent.REGULATOR;
        }
        if (this.connectorNodes.contains(l)) {
            return NetworkComponent.CONNECTOR;
        }
        if (this.terminusNodes.contains(l)) {
            return NetworkComponent.TERMINUS;
        }
        return null;
    }

    private void discoverStep() {
        int steps = 0;
        while (this.nodeQueue.peek() != null) {
            Location l = this.nodeQueue.poll();
            NetworkComponent currentAssignment = this.getCurrentClassification(l);
            NetworkComponent classification = this.classifyLocation(l);
            if (classification != currentAssignment) {
                if (currentAssignment == NetworkComponent.REGULATOR || currentAssignment == NetworkComponent.CONNECTOR) {
                    Network.unregisterNetwork(this);
                    return;
                }
                if (currentAssignment == NetworkComponent.TERMINUS) {
                    this.terminusNodes.remove(l);
                }
                if (classification == NetworkComponent.REGULATOR) {
                    this.regulatorNodes.add(l);
                    this.discoverNeighbors(l);
                } else if (classification == NetworkComponent.CONNECTOR) {
                    this.connectorNodes.add(l);
                    this.discoverNeighbors(l);
                } else if (classification == NetworkComponent.TERMINUS) {
                    this.terminusNodes.add(l);
                }
                this.locationClassificationChange(l, currentAssignment, classification);
            }
            if (++steps != 500) continue;
            break;
        }
    }

    private void discoverNeighbors(Location l, double xDiff, double yDiff, double zDiff) {
        for (int i = this.getRange() + 1; i > 0; --i) {
            Location newLocation = l.clone().add((double)i * xDiff, (double)i * yDiff, (double)i * zDiff);
            this.addLocationToNetwork(newLocation);
        }
    }

    private void discoverNeighbors(Location l) {
        this.discoverNeighbors(l, 1.0, 0.0, 0.0);
        this.discoverNeighbors(l, -1.0, 0.0, 0.0);
        this.discoverNeighbors(l, 0.0, 1.0, 0.0);
        this.discoverNeighbors(l, 0.0, -1.0, 0.0);
        this.discoverNeighbors(l, 0.0, 0.0, 1.0);
        this.discoverNeighbors(l, 0.0, 0.0, -1.0);
    }

    public void display() {
        Slimefun.runSync(() -> {
            for (Location l : this.connectedLocations) {
                try {
                    ParticleEffect.REDSTONE.display(l.clone().add(0.5, 0.5, 0.5), 0.0f, 0.0f, 0.0f, 1.0f, 1);
                }
                catch (Exception x) {
                    Slimefun.getLogger().log(Level.SEVERE, "An Error occured while playing Network Animation for Slimefun " + Slimefun.getVersion(), x);
                }
            }
        });
    }

    public void tick() {
        this.discoverStep();
    }
}

