/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;

public abstract class JsonDataHolder {
    protected JsonObject data;
    private boolean dirty;

    public JsonDataHolder() {
        this(null);
    }

    public JsonDataHolder(JsonObject data) {
        this.data = data != null ? data : new JsonObject();
        this.dirty = false;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void markClean() {
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setString(String key, String value) {
        this.data.addProperty(key, value);
        this.markDirty();
    }

    public void setInt(String key, int value) {
        this.data.addProperty(key, (Number)value);
        this.markDirty();
    }

    public void setBoolean(String key, boolean value) {
        this.data.addProperty(key, Boolean.valueOf(value));
        this.markDirty();
    }

    public void setFloat(String key, float value) {
        this.data.addProperty(key, (Number)Float.valueOf(value));
        this.markDirty();
    }

    public void setStringArray(String key, String[] array) {
        JsonArray json = new JsonArray();
        for (String value : array) {
            json.add(value);
        }
        this.data.add(key, (JsonElement)json);
        this.markDirty();
    }

    public void setIntArray(String key, int[] array) {
        JsonArray json = new JsonArray();
        for (int value : array) {
            json.add((Number)value);
        }
        this.data.add(key, (JsonElement)json);
        this.markDirty();
    }

    public void setBooleanArray(String key, boolean[] array) {
        JsonArray json = new JsonArray();
        for (boolean value : array) {
            json.add(Boolean.valueOf(value));
        }
        this.data.add(key, (JsonElement)json);
        this.markDirty();
    }

    public void setFloatArray(String key, float[] array) {
        JsonArray json = new JsonArray();
        for (float value : array) {
            json.add((Number)Float.valueOf(value));
        }
        this.data.add(key, (JsonElement)json);
        this.markDirty();
    }

    public Optional<String> getString(String key) {
        return this.getPrimitive(key, JsonElement::getAsString);
    }

    public String getString(String key, String defaultValue) {
        return this.getString(key).orElse(defaultValue);
    }

    public Optional<Integer> getInt(String key) {
        return this.getPrimitive(key, JsonElement::getAsInt);
    }

    public int getInt(String key, int defaultValue) {
        return this.getInt(key).orElse(defaultValue);
    }

    public Optional<Boolean> getBoolean(String key) {
        return this.getPrimitive(key, JsonElement::getAsBoolean);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key).orElse(defaultValue);
    }

    public Optional<Float> getFloat(String key) {
        return this.getPrimitive(key, JsonElement::getAsFloat);
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFloat(key).orElse(Float.valueOf(defaultValue)).floatValue();
    }

    public Optional<String[]> getStringArray(String key) {
        return this.getArray(key, String[]::new, JsonElement::getAsString);
    }

    public Optional<Integer[]> getIntArray(String key) {
        return this.getArray(key, Integer[]::new, JsonElement::getAsInt);
    }

    public Optional<Boolean[]> getBooleanArray(String key) {
        return this.getArray(key, Boolean[]::new, JsonElement::getAsBoolean);
    }

    public Optional<Float[]> getFloatArray(String key) {
        return this.getArray(key, Float[]::new, JsonElement::getAsFloat);
    }

    protected <T> Optional<T[]> getArray(String key, IntFunction<T[]> constructor, Function<JsonElement, T> getter) {
        JsonElement element = this.data.get(key);
        if (element instanceof JsonArray) {
            JsonArray json = (JsonArray)element;
            T[] array = constructor.apply(json.size());
            for (int i = 0; i < array.length; ++i) {
                array[i] = getter.apply(json.get(i));
            }
            return Optional.of(array);
        }
        return Optional.empty();
    }

    protected <T> Optional<T> getPrimitive(String key, Function<JsonElement, T> getter) {
        JsonElement element = this.data.get(key);
        if (element instanceof JsonPrimitive) {
            return Optional.of(getter.apply(element));
        }
        return Optional.empty();
    }
}

