/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ChestMenuListener;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.InvUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.MenuClickHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ChestMenu
implements Cloneable,
Iterable<ItemStack> {
    protected static ChestMenuListener listener;
    protected boolean playerInventoryClickable;
    protected Plugin plugin;
    protected Consumer<Player> menuOpeningHandler;
    protected Consumer<Player> menuClosingHandler;
    protected String title;
    protected boolean emptyClickable;
    protected Inventory inv;
    protected List<ItemStack> items;
    protected Map<Integer, MenuClickHandler> handlers;
    protected MenuClickHandler playerclick;
    protected Predicate<ItemStack> predicate;
    protected int size;
    protected int timeout;
    protected Runnable deprecationRunnable;
    protected BukkitTask deprecationTask;
    protected Runnable dirtyRunnable;

    public ChestMenu(Plugin plugin, String title, Runnable dirtyRunnable) {
        if (listener == null) {
            listener = new ChestMenuListener(plugin);
        }
        this.plugin = plugin;
        this.title = ChatColor.translateAlternateColorCodes((char)'&', (String)title);
        this.playerInventoryClickable = true;
        this.emptyClickable = true;
        this.items = new LinkedList<ItemStack>();
        this.handlers = new HashMap<Integer, MenuClickHandler>();
        this.timeout = -1;
        this.dirtyRunnable = dirtyRunnable;
        this.menuOpeningHandler = p -> {};
        this.menuClosingHandler = p -> {};
        this.playerclick = (p, slot, item, cursor, action) -> this.isPlayerInventoryClickable();
    }

    public ChestMenu(Plugin plugin, String title) {
        this(plugin, title, () -> {});
    }

    protected ChestMenu(ChestMenu menu) {
        this.plugin = menu.plugin;
        this.title = menu.title;
        this.playerInventoryClickable = menu.playerInventoryClickable;
        this.emptyClickable = menu.emptyClickable;
        this.items = menu.items;
        this.handlers = menu.handlers;
        this.timeout = menu.timeout;
        this.menuOpeningHandler = menu.menuOpeningHandler;
        this.menuClosingHandler = menu.menuClosingHandler;
        this.playerclick = menu.playerclick;
    }

    public boolean preventsItems(ItemStack item) {
        if (item == null || this.predicate == null) {
            return false;
        }
        return this.predicate.test(item);
    }

    public void preventItems(Predicate<ItemStack> predicate) {
        this.predicate = predicate;
    }

    public void markDirty() {
        if (this.dirtyRunnable != null) {
            this.dirtyRunnable.run();
        }
    }

    public void setPlayerInventoryClickable(boolean clickable) {
        this.playerInventoryClickable = clickable;
    }

    public Map<Integer, MenuClickHandler> getClickHandlers() {
        return this.handlers;
    }

    public void setEmptySlotsClickable(boolean emptyClickable) {
        this.emptyClickable = emptyClickable;
    }

    public boolean areEmptySlotsClickable() {
        return this.emptyClickable;
    }

    public void setPlayerInventoryClickHandler(MenuClickHandler handler) {
        this.playerclick = handler;
    }

    public ChestMenu addItem(int slot, ItemStack item) {
        if (this.size > slot) {
            this.items.set(slot, item);
            if (this.inv != null) {
                this.inv.setItem(slot, item);
            }
        } else {
            for (int i = 0; i < slot - this.size; ++i) {
                this.items.add(null);
            }
            this.items.add(item);
            this.size = slot + 1;
        }
        return this;
    }

    public ChestMenu addItem(int slot, ItemStack item, MenuClickHandler handler) {
        this.addItem(slot, item);
        this.addMenuClickHandler(slot, handler);
        return this;
    }

    public ChestMenu remove(int slot) {
        this.items.set(slot, null);
        this.handlers.remove(slot);
        return this;
    }

    public ItemStack getItemInSlot(int slot) {
        this.setup();
        return this.inv.getItem(slot);
    }

    public ChestMenu addMenuClickHandler(int slot, MenuClickHandler handler) {
        this.handlers.put(slot, handler);
        return this;
    }

    public ChestMenu addMenuOpeningHandler(Consumer<Player> handler) {
        this.menuOpeningHandler = handler;
        return this;
    }

    public ChestMenu addMenuCloseHandler(Consumer<Player> handler) {
        this.menuClosingHandler = handler;
        return this;
    }

    public ItemStack[] getContents() {
        this.setup();
        return this.inv.getContents();
    }

    protected void setup() {
        if (this.inv != null) {
            return;
        }
        this.inv = Bukkit.createInventory(null, (int)(ChestMenu.formToLine(this.size) * 9), (String)this.title);
        int i = 0;
        for (ItemStack item : this.items) {
            this.inv.setItem(i, item);
            ++i;
        }
    }

    public void reset(boolean update) {
        if (update) {
            this.inv.clear();
        } else {
            this.inv = Bukkit.createInventory(null, (int)(ChestMenu.formToLine(this.size) * 9), (String)this.title);
        }
        int i = 0;
        for (ItemStack item : this.items) {
            this.inv.setItem(i, item);
            ++i;
        }
    }

    public void replaceExistingItem(int slot, ItemStack item) {
        this.setup();
        this.inv.setItem(slot, item);
    }

    public void open(Player ... players) {
        if (players.length == 0) {
            return;
        }
        this.setup();
        if (this.deprecationTask != null) {
            this.deprecationTask.cancel();
        }
        for (Player p : players) {
            p.openInventory(this.inv);
            ChestMenu.listener.menus.put(p.getUniqueId(), this);
            this.menuOpeningHandler.accept(p);
        }
    }

    public MenuClickHandler getMenuClickHandler(int slot) {
        return this.handlers.get(slot);
    }

    public MenuClickHandler getPlayerInventoryClickHandler() {
        return this.playerclick;
    }

    public Inventory toInventory() {
        this.setup();
        return this.inv;
    }

    public void close() {
        if (this.inv == null) {
            return;
        }
        Iterator iterator = new ArrayList(this.inv.getViewers()).iterator();
        while (iterator.hasNext()) {
            ((HumanEntity)iterator.next()).closeInventory();
        }
    }

    protected static int formToLine(int i) {
        return (int)Math.ceil((float)i / 9.0f);
    }

    public void consumeItem(int slot, boolean replaceConsumables) {
        this.consumeItem(slot, 1, replaceConsumables);
    }

    public void consumeItem(int slot, int amount, boolean replaceConsumables) {
        ItemStack item = this.getItemInSlot(slot);
        if (item != null && item.getType() != Material.AIR) {
            ItemUtils.consumeItem(item, amount, replaceConsumables);
            this.markDirty();
        }
    }

    public boolean pushItem(ItemStack item, int ... slots) {
        for (int slot : slots) {
            ItemStack stack = this.getItemInSlot(slot);
            if (stack == null || stack.getType() == Material.AIR) {
                this.toInventory().setItem(slot, item);
                this.markDirty();
                return true;
            }
            if (stack.getAmount() + item.getAmount() > stack.getMaxStackSize() || !ItemUtils.canStack(stack, item)) continue;
            stack.setAmount(stack.getAmount() + item.getAmount());
            this.toInventory().setItem(slot, stack);
            this.markDirty();
            return true;
        }
        return false;
    }

    public boolean fits(ItemStack item, int ... slots) {
        return InvUtils.fits(this.toInventory(), item, slots);
    }

    @Override
    public Iterator<ItemStack> iterator() {
        this.setup();
        return this.inv.iterator();
    }

    public void setTimeout(int ticks, Runnable runnable) {
        if (this.deprecationTask != null) {
            this.deprecationTask.cancel();
        }
        this.timeout = ticks;
        this.deprecationRunnable = runnable;
    }

    protected void runTimeout() {
        if (this.timeout >= 0 && this.toInventory().getViewers().size() <= 1) {
            this.deprecationTask = this.plugin.getServer().getScheduler().runTaskLater(this.plugin, () -> {
                this.close();
                this.deprecationRunnable.run();
                this.deprecationTask = null;
            }, (long)this.timeout);
        }
    }

    protected void onClose(Player p) {
        this.menuClosingHandler.accept(p);
        this.runTimeout();
    }

    public ChestMenu clone() {
        return new ChestMenu(this);
    }

    public boolean isPlayerInventoryClickable() {
        return this.playerInventoryClickable;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Consumer<Player> getMenuOpeningHandler() {
        return this.menuOpeningHandler;
    }

    public Consumer<Player> getMenuClosingHandler() {
        return this.menuClosingHandler;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

