/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines.electric;

import java.util.Random;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.InvUtils;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.utils.MachineHelper;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public abstract class ElectricDustWasher
extends AContainer {
    public ElectricDustWasher(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public String getInventoryTitle() {
        return "&bElectric Dust Washer";
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.GOLDEN_SHOVEL);
    }

    @Override
    public abstract int getSpeed();

    @Override
    protected void tick(Block b) {
        block13: {
            BlockMenu menu;
            block11: {
                block12: {
                    menu = BlockStorage.getInventory(b);
                    if (!this.isProcessing(b)) break block11;
                    int timeleft = (Integer)progress.get(b);
                    if (timeleft <= 0 || this.getSpeed() >= 10) break block12;
                    MachineHelper.updateProgressbar(menu, 22, timeleft, ((MachineRecipe)processing.get(b)).getTicks(), this.getProgressBar());
                    if (ChargableBlock.isChargable(b)) {
                        if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                            return;
                        }
                        ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                        progress.put(b, timeleft - 1);
                    } else {
                        progress.put(b, timeleft - 1);
                    }
                    break block13;
                }
                if (!ChargableBlock.isChargable(b)) break block13;
                if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                    return;
                }
                ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                menu.replaceExistingItem(22, (ItemStack)new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " "));
                this.pushItems(b, ((MachineRecipe)processing.get(b)).getOutput());
                progress.remove(b);
                processing.remove(b);
                break block13;
            }
            ItemStack[] items = SlimefunPlugin.getUtilities().oreWasherOutputs;
            for (int slot : this.getInputSlots()) {
                if (SlimefunManager.isItemSimiliar(menu.getItemInSlot(slot), SlimefunItems.SIFTED_ORE, true)) {
                    if (!SlimefunPlugin.getSettings().legacyDustWasher) {
                        boolean emptySlot = false;
                        for (int output_slot : this.getOutputSlots()) {
                            if (menu.getItemInSlot(output_slot) != null) continue;
                            emptySlot = true;
                            break;
                        }
                        if (!emptySlot) {
                            return;
                        }
                    }
                    ItemStack adding = items[new Random().nextInt(items.length)];
                    MachineRecipe r = new MachineRecipe(4 / this.getSpeed(), new ItemStack[0], new ItemStack[]{adding});
                    if (SlimefunPlugin.getSettings().legacyDustWasher && !this.fits(b, r.getOutput())) {
                        return;
                    }
                    menu.replaceExistingItem(slot, InvUtils.decreaseItem((ItemStack)menu.getItemInSlot(slot), (int)1));
                    processing.put(b, r);
                    progress.put(b, r.getTicks());
                    break;
                }
                if (!SlimefunManager.isItemSimiliar(menu.getItemInSlot(slot), SlimefunItems.PULVERIZED_ORE, true)) continue;
                MachineRecipe r = new MachineRecipe(4 / this.getSpeed(), new ItemStack[0], new ItemStack[]{SlimefunItems.PURE_ORE_CLUSTER});
                if (!this.fits(b, r.getOutput())) {
                    return;
                }
                menu.replaceExistingItem(slot, InvUtils.decreaseItem((ItemStack)menu.getItemInSlot(slot), (int)1));
                processing.put(b, r);
                progress.put(b, r.getTicks());
                break;
            }
        }
    }

    @Override
    public String getMachineIdentifier() {
        return "ELECTRIC_DUST_WASHER";
    }
}

