/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SimpleSlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.RecipeDisplayItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemInteractionHandler;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.SlimefunPlugin;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;

public class GoldPan
extends SimpleSlimefunItem<ItemInteractionHandler>
implements RecipeDisplayItem {
    private final Random random = new Random();
    private final List<ItemStack> recipes = Arrays.asList(new ItemStack(Material.GRAVEL), new ItemStack(Material.FLINT), new ItemStack(Material.GRAVEL), new ItemStack(Material.CLAY_BALL), new ItemStack(Material.GRAVEL), SlimefunItems.SIFTED_ORE);
    private int chanceSiftedOre;
    private int chanceFlint;
    private int chanceClay;

    public GoldPan(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, String[] keys, Object[] values) {
        super(category, item, recipeType, recipe, keys, values);
    }

    @Override
    public void postRegister() {
        this.chanceSiftedOre = (Integer)Slimefun.getItemValue(this.getID(), "chance.SIFTED_ORE");
        this.chanceClay = (Integer)Slimefun.getItemValue(this.getID(), "chance.CLAY");
        this.chanceFlint = (Integer)Slimefun.getItemValue(this.getID(), "chance.FLINT");
    }

    @Override
    public ItemInteractionHandler getItemHandler() {
        return (e, p, item) -> {
            if (SlimefunManager.isItemSimiliar(item, SlimefunItems.GOLD_PAN, true)) {
                if (e.getClickedBlock() != null && e.getClickedBlock().getType() == Material.GRAVEL && SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, e.getClickedBlock().getLocation(), ProtectableAction.BREAK_BLOCK)) {
                    ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                    if (this.random.nextInt(100) < this.chanceSiftedOre) {
                        drops.add(SlimefunItems.SIFTED_ORE);
                    } else if (this.random.nextInt(100) < this.chanceClay) {
                        drops.add(new ItemStack(Material.CLAY_BALL));
                    } else if (this.random.nextInt(100) < this.chanceFlint) {
                        drops.add(new ItemStack(Material.FLINT));
                    }
                    e.getClickedBlock().getWorld().playEffect(e.getClickedBlock().getLocation(), Effect.STEP_SOUND, (Object)e.getClickedBlock().getType());
                    e.getClickedBlock().setType(Material.AIR);
                    for (ItemStack drop : drops) {
                        e.getClickedBlock().getWorld().dropItemNaturally(e.getClickedBlock().getLocation(), drop);
                    }
                }
                e.setCancelled(true);
                return true;
            }
            return false;
        };
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        return this.recipes;
    }
}

