/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;

public final class ReflectionUtils {
    private static final Map<Class<?>, Class<?>> conversion = new HashMap();
    private static String currentVersion;

    private ReflectionUtils() {
    }

    public static Method getMethod(Class<?> c, String method) {
        for (Method m : c.getMethods()) {
            if (!m.getName().equals(method)) continue;
            return m;
        }
        return null;
    }

    public static Method getMethod(Class<?> c, String method, Class<?> ... paramTypes) {
        Class<?>[] t = ReflectionUtils.toPrimitiveTypeArray(paramTypes);
        for (Method m : c.getMethods()) {
            Class<?>[] types = ReflectionUtils.toPrimitiveTypeArray(m.getParameterTypes());
            if (!m.getName().equals(method) || !ReflectionUtils.equalsTypeArray(types, t)) continue;
            return m;
        }
        return null;
    }

    public static Field getField(Class<?> c, String field) throws NoSuchFieldException {
        return c.getDeclaredField(field);
    }

    public static <T> void setFieldValue(T object, Class<?> c, String field, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field f = ReflectionUtils.getField(c, field);
        f.setAccessible(true);
        f.set(object, value);
    }

    public static <T> void setFieldValue(T object, String field, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field f = ReflectionUtils.getField(object.getClass(), field);
        f.setAccessible(true);
        f.set(object, value);
    }

    public static Object getFieldValue(Object object, String field) throws NoSuchFieldException, IllegalAccessException {
        Field f = ReflectionUtils.getField(object.getClass(), field);
        f.setAccessible(true);
        return f.get(object);
    }

    public static Class<?>[] toPrimitiveTypeArray(Class<?> ... classes) {
        int a = classes != null ? classes.length : 0;
        Class[] types = new Class[a];
        for (int i = 0; i < a; ++i) {
            types[i] = conversion.containsKey(classes[i]) ? conversion.get(classes[i]) : classes[i];
        }
        return types;
    }

    public static Class<?>[] toPrimitiveTypeArray(Object ... objects) {
        int a = objects != null ? objects.length : 0;
        Class[] types = new Class[a];
        for (int i = 0; i < a; ++i) {
            types[i] = conversion.containsKey(objects[i].getClass()) ? conversion.get(objects[i].getClass()) : objects[i].getClass();
        }
        return types;
    }

    public static <T> Constructor<T> getConstructor(Class<T> c, Class<?> ... paramTypes) {
        Class<?>[] t = ReflectionUtils.toPrimitiveTypeArray(paramTypes);
        for (Constructor<?> constructor : c.getConstructors()) {
            Class<?>[] types = ReflectionUtils.toPrimitiveTypeArray(constructor.getParameterTypes());
            if (!ReflectionUtils.equalsTypeArray(types, t)) continue;
            return constructor;
        }
        return null;
    }

    public static Class<?> getInnerNMSClass(String name, String subname) throws ClassNotFoundException {
        return ReflectionUtils.getNMSClass(name + "$" + subname);
    }

    public static Class<?> getNMSClass(String name) throws ClassNotFoundException {
        return Class.forName("net.minecraft.server." + ReflectionUtils.getVersion() + "." + name);
    }

    public static Class<?> getInnerOBCClass(String name, String subname) throws ClassNotFoundException {
        return ReflectionUtils.getOBCClass(name + "$" + subname);
    }

    public static Class<?> getOBCClass(String name) throws ClassNotFoundException {
        return Class.forName("org.bukkit.craftbukkit." + ReflectionUtils.getVersion() + "." + name);
    }

    public static String getVersion() {
        if (currentVersion == null) {
            currentVersion = Bukkit.getServer().getClass().getPackage().getName().substring(Bukkit.getServer().getClass().getPackage().getName().lastIndexOf(46) + 1);
        }
        return currentVersion;
    }

    public static boolean isVersion(String ... prefixes) {
        String version = ReflectionUtils.getVersion();
        for (String prefix : prefixes) {
            if (!version.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static boolean equalsTypeArray(Class<?>[] a, Class<?> ... o) {
        if (a.length != o.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(o[i]) || a[i].isAssignableFrom(o[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> List<T> getEnumConstants(Class<T> c) {
        return Arrays.asList(c.getEnumConstants());
    }

    public static <T> T getEnumConstant(Class<T> c, String name) {
        for (T o : c.getEnumConstants()) {
            if (!o.toString().equals(name)) continue;
            return o;
        }
        return null;
    }

    static {
        conversion.put(Byte.class, Byte.TYPE);
        conversion.put(Short.class, Short.TYPE);
        conversion.put(Integer.class, Integer.TYPE);
        conversion.put(Long.class, Long.TYPE);
        conversion.put(Character.class, Character.TYPE);
        conversion.put(Float.class, Float.TYPE);
        conversion.put(Double.class, Double.TYPE);
        conversion.put(Boolean.class, Boolean.TYPE);
    }
}

