/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines.electric;

import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.InvUtils;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public class AutoBreeder
extends SlimefunItem
implements InventoryBlock {
    private static final int[] border = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    protected int energyConsumption = 60;

    public AutoBreeder(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.createPreset(this, "&6Auto Breeder", this::constructMenu);
        AutoBreeder.registerBlockHandler(this.getID(), (p, b, tool, reason) -> {
            BlockMenu inv = BlockStorage.getInventory(b);
            if (inv != null) {
                for (int slot : this.getInputSlots()) {
                    if (inv.getItemInSlot(slot) == null) continue;
                    b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                    inv.replaceExistingItem(slot, null);
                }
            }
            return true;
        });
    }

    protected void constructMenu(BlockMenuPreset preset) {
        for (int i : border) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.CYAN_STAINED_GLASS_PANE), " "), (p, slot, item, action) -> false);
        }
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{10, 11, 12, 13, 14, 15, 16};
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public void preRegister() {
        this.addItemHandler(new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem sf, Config data) {
                AutoBreeder.this.tick(b);
            }

            @Override
            public boolean isSynchronized() {
                return true;
            }
        });
    }

    protected void tick(Block b) {
        for (Entity n2 : b.getWorld().getNearbyEntities(b.getLocation(), 4.0, 2.0, 4.0, n -> n instanceof Animals && n.isValid() && ((Animals)n).isAdult() && !((Animals)n).isLoveMode())) {
            for (int slot : this.getInputSlots()) {
                if (!SlimefunManager.isItemSimiliar(BlockStorage.getInventory(b).getItemInSlot(slot), SlimefunItems.ORGANIC_FOOD, false)) continue;
                if (ChargableBlock.getCharge(b) < this.energyConsumption) {
                    return;
                }
                ChargableBlock.addCharge(b, -this.energyConsumption);
                BlockStorage.getInventory(b).replaceExistingItem(slot, InvUtils.decreaseItem((ItemStack)BlockStorage.getInventory(b).getItemInSlot(slot), (int)1));
                ((Animals)n2).setLoveModeTicks(600);
                n2.getWorld().spawnParticle(Particle.HEART, ((LivingEntity)n2).getEyeLocation(), 8, (double)0.2f, (double)0.2f, (double)0.2f);
                return;
            }
        }
    }
}

