/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils.tags;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import io.github.thebusybiscuit.slimefun4.api.exceptions.TagMisconfigurationException;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import io.github.thebusybiscuit.slimefun4.utils.JsonUtils;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;

public class TagParser
implements Keyed {
    private final NamespacedKey key;

    public TagParser(@Nonnull NamespacedKey key) {
        this.key = key;
    }

    TagParser(@Nonnull SlimefunTag tag) {
        this(tag.getKey());
    }

    void parse(@Nonnull SlimefunTag tag, @Nonnull BiConsumer<Set<Material>, Set<Tag<Material>>> callback) throws TagMisconfigurationException {
        String path = "/tags/" + tag.getKey().getKey() + ".json";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Slimefun.class.getResourceAsStream(path), StandardCharsets.UTF_8));){
            this.parse(reader.lines().collect(Collectors.joining("")), callback);
        }
        catch (IOException x) {
            throw new TagMisconfigurationException(this.key, (Throwable)x);
        }
    }

    public void parse(@Nonnull String json, @Nonnull BiConsumer<Set<Material>, Set<Tag<Material>>> callback) throws TagMisconfigurationException {
        Validate.notNull(json, "Cannot parse a null String");
        try {
            EnumSet<Material> materials = EnumSet.noneOf(Material.class);
            HashSet<Tag<Material>> tags = new HashSet<Tag<Material>>();
            JsonObject root = JsonUtils.parseString(json).getAsJsonObject();
            JsonElement child = root.get("values");
            if (child instanceof JsonArray) {
                JsonArray values = child.getAsJsonArray();
                for (JsonElement element : values) {
                    JsonPrimitive primitive;
                    if (element instanceof JsonPrimitive && (primitive = (JsonPrimitive)element).isString()) {
                        this.parsePrimitiveValue(element.getAsString(), materials, tags, true);
                        continue;
                    }
                    if (element instanceof JsonObject) {
                        this.parseComplexValue(element.getAsJsonObject(), materials, tags);
                        continue;
                    }
                    throw new TagMisconfigurationException(this.key, "Unexpected value format: " + element.getClass().getSimpleName() + " - " + element.toString());
                }
            } else {
                throw new TagMisconfigurationException(this.key, "No values array specified");
            }
            callback.accept(materials, tags);
        }
        catch (JsonParseException | IllegalStateException x) {
            throw new TagMisconfigurationException(this.key, x);
        }
    }

    @ParametersAreNonnullByDefault
    private void parsePrimitiveValue(String value, Set<Material> materials, Set<Tag<Material>> tags, boolean throwException) throws TagMisconfigurationException {
        if (PatternUtils.MINECRAFT_NAMESPACEDKEY.matcher(value).matches()) {
            Material material = Material.matchMaterial((String)value);
            if (material != null) {
                materials.add(material);
            } else if (throwException) {
                throw new TagMisconfigurationException(this.key, "Minecraft Material '" + value + "' seems to not exist!");
            }
        } else if (PatternUtils.MINECRAFT_TAG.matcher(value).matches()) {
            String keyValue = CommonPatterns.COLON.split(value)[1];
            NamespacedKey namespacedKey = NamespacedKey.minecraft((String)keyValue);
            Tag itemsTag = Bukkit.getTag((String)"items", (NamespacedKey)namespacedKey, Material.class);
            Tag blocksTag = Bukkit.getTag((String)"blocks", (NamespacedKey)namespacedKey, Material.class);
            if (itemsTag != null) {
                tags.add((Tag<Material>)itemsTag);
            } else if (blocksTag != null) {
                tags.add((Tag<Material>)blocksTag);
            } else if (throwException) {
                throw new TagMisconfigurationException(this.key, "There is no '" + value + "' tag in Minecraft.");
            }
        } else if (PatternUtils.SLIMEFUN_TAG.matcher(value).matches()) {
            String keyValue = CommonPatterns.COLON.split(value)[1].toUpperCase(Locale.ROOT);
            SlimefunTag tag = SlimefunTag.getTag(keyValue);
            if (tag != null) {
                tags.add(tag);
            } else if (throwException) {
                throw new TagMisconfigurationException(this.key, "There is no '" + value + "' tag in Slimefun");
            }
        } else if (throwException) {
            throw new TagMisconfigurationException(this.key, "Could not recognize value '" + value + "'");
        }
    }

    @ParametersAreNonnullByDefault
    private void parseComplexValue(JsonObject entry, Set<Material> materials, Set<Tag<Material>> tags) throws TagMisconfigurationException {
        JsonPrimitive requiredJson;
        JsonPrimitive idJson;
        JsonElement id = entry.get("id");
        JsonElement required = entry.get("required");
        if (!(id instanceof JsonPrimitive && (idJson = (JsonPrimitive)id).isString() && required instanceof JsonPrimitive && (requiredJson = (JsonPrimitive)required).isBoolean())) {
            throw new TagMisconfigurationException(this.key, "Found a JSON Object value without an id!");
        }
        boolean isRequired = required.getAsBoolean();
        this.parsePrimitiveValue(id.getAsString(), materials, tags, isRequired);
    }

    @Nonnull
    public NamespacedKey getKey() {
        return this.key;
    }
}

