/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.dough.updater;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.AbstractPluginUpdater;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.PluginUpdater;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.UpdateInfo;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.UpdaterTask;
import io.github.thebusybiscuit.slimefun4.libraries.dough.versions.SemanticVersion;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.bukkit.plugin.Plugin;

public class BukkitUpdater
extends AbstractPluginUpdater<SemanticVersion> {
    private static final String API_URL = "https://api.curseforge.com/servermods/files?projectIds=";
    private final int projectId;

    public BukkitUpdater(@Nonnull Plugin plugin, @Nonnull File file, int id) {
        super(plugin, file, BukkitUpdater.getVersion(plugin));
        this.projectId = id;
    }

    @Nonnull
    private static SemanticVersion getVersion(@Nonnull Plugin plugin) {
        String pluginVersion = plugin.getDescription().getVersion().toLowerCase(Locale.ROOT);
        return SemanticVersion.parse(pluginVersion);
    }

    @Override
    public void start() {
        try {
            URL url = new URL(API_URL + this.projectId);
            this.scheduleAsyncUpdateTask(new UpdaterTask<SemanticVersion>((PluginUpdater)this, url){

                @Override
                public UpdateInfo parse(String result) throws MalformedURLException {
                    JsonArray array = (JsonArray)new JsonParser().parse(result);
                    if (array.size() == 0) {
                        BukkitUpdater.this.getLogger().log(Level.WARNING, "The Auto-Updater could not connect to dev.bukkit.org, is it down?");
                        return null;
                    }
                    JsonObject latest = array.get(array.size() - 1).getAsJsonObject();
                    URL download = new URL(latest.get("downloadUrl").getAsString());
                    String remoteVersion = latest.getAsJsonObject().get("name").getAsString();
                    remoteVersion = remoteVersion.toLowerCase(Locale.ROOT);
                    SemanticVersion latestVersion = SemanticVersion.parse(remoteVersion);
                    BukkitUpdater.this.getLatestVersion().complete(latestVersion);
                    return new UpdateInfo(download, latestVersion);
                }
            });
        }
        catch (MalformedURLException e) {
            this.getLogger().log(Level.SEVERE, "Auto-Updater URL is malformed", e);
        }
    }
}

