/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners.crafting;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.crafting.SlimefunCraftingListener;
import javax.annotation.Nonnull;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.plugin.Plugin;

public class SmithingTableListener
implements SlimefunCraftingListener {
    public SmithingTableListener(@Nonnull Slimefun plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onSmith(SmithItemEvent e) {
        SlimefunItem sfItem = SlimefunItem.getByItem(e.getInventory().getContents()[this.materialSlot()]);
        if (sfItem != null && !sfItem.isUseableInWorkbench()) {
            e.setResult(Event.Result.DENY);
            Slimefun.getLocalization().sendMessage((CommandSender)e.getWhoClicked(), "smithing_table.not-working", true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPrepareSmith(PrepareSmithingEvent e) {
        SlimefunItem sfItem;
        if (e.getInventory().getResult() != null && (sfItem = SlimefunItem.getByItem(e.getInventory().getContents()[this.materialSlot()])) != null && !sfItem.isUseableInWorkbench()) {
            e.setResult(null);
        }
    }

    private int materialSlot() {
        if (Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_20)) {
            return 2;
        }
        return 1;
    }
}

