/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.enchanting;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BookBinder
extends AContainer {
    private final ItemSetting<Boolean> bypassVanillaMaxLevel = new ItemSetting<Boolean>(this, "bypass-vanilla-max-level", false);
    private final ItemSetting<Boolean> hasCustomMaxLevel = new ItemSetting<Boolean>(this, "has-custom-max-level", false);
    private final ItemSetting<Integer> customMaxLevel = new IntRangeSetting(this, "custom-max-level", 0, 15, Integer.MAX_VALUE);

    @ParametersAreNonnullByDefault
    public BookBinder(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.addItemSetting(this.bypassVanillaMaxLevel, this.hasCustomMaxLevel, this.customMaxLevel);
    }

    @Override
    protected MachineRecipe findNextRecipe(BlockMenu menu) {
        for (int slot : this.getInputSlots()) {
            Map storedTargetEnchantments;
            ItemStack target = menu.getItemInSlot(slot == this.getInputSlots()[0] ? this.getInputSlots()[1] : this.getInputSlots()[0]);
            ItemStack item = menu.getItemInSlot(slot);
            if (!this.isCompatible(item) || !this.isCompatible(target)) continue;
            EnchantmentStorageMeta itemMeta = (EnchantmentStorageMeta)item.getItemMeta();
            EnchantmentStorageMeta targetMeta = (EnchantmentStorageMeta)target.getItemMeta();
            Map storedItemEnchantments = itemMeta.getStoredEnchants();
            Map<Enchantment, Integer> enchantments = this.combineEnchantments(storedItemEnchantments, storedTargetEnchantments = targetMeta.getStoredEnchants());
            if (enchantments.size() > 0) {
                if (this.hasIllegalEnchants(storedItemEnchantments) || this.hasIllegalEnchants(storedTargetEnchantments)) {
                    return null;
                }
                ItemStack book = new ItemStack(Material.ENCHANTED_BOOK);
                EnchantmentStorageMeta enchantMeta = (EnchantmentStorageMeta)book.getItemMeta();
                for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
                    enchantMeta.addStoredEnchant(entry.getKey(), entry.getValue().intValue(), this.bypassVanillaMaxLevel.getValue().booleanValue());
                }
                if (enchantMeta.getStoredEnchants().isEmpty()) {
                    return null;
                }
                if (enchantMeta.getStoredEnchants().equals(storedItemEnchantments) || enchantMeta.getStoredEnchants().equals(storedTargetEnchantments)) {
                    return null;
                }
                book.setItemMeta((ItemMeta)enchantMeta);
                MachineRecipe recipe = new MachineRecipe(25 * (enchantments.size() / this.getSpeed()), new ItemStack[]{target, item}, new ItemStack[]{book});
                if (!InvUtils.fitAll(menu.toInventory(), recipe.getOutput(), this.getOutputSlots())) {
                    return null;
                }
                for (int inputSlot : this.getInputSlots()) {
                    menu.consumeItem(inputSlot);
                }
                return recipe;
            }
            return null;
        }
        return null;
    }

    private boolean isCompatible(@Nullable ItemStack item) {
        return item != null && item.getType() == Material.ENCHANTED_BOOK;
    }

    private boolean hasIllegalEnchants(@Nullable Map<Enchantment, Integer> enchantments) {
        if (enchantments == null) {
            return false;
        }
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            if ((!this.bypassVanillaMaxLevel.getValue().booleanValue() || entry.getValue() <= this.customMaxLevel.getValue()) && (this.bypassVanillaMaxLevel.getValue().booleanValue() || entry.getValue() <= entry.getKey().getMaxLevel())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.IRON_CHESTPLATE);
    }

    @Override
    public String getMachineIdentifier() {
        return "BOOK_BINDER";
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private Map<Enchantment, Integer> combineEnchantments(Map<Enchantment, Integer> ech1, Map<Enchantment, Integer> ech2) {
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        enchantments.putAll(ech1);
        boolean hasConflicts = false;
        for (Map.Entry<Enchantment, Integer> entry : ech2.entrySet()) {
            for (Map.Entry conflictsWith : enchantments.entrySet()) {
                if (!entry.getKey().conflictsWith((Enchantment)conflictsWith.getKey()) || entry.getKey().equals(conflictsWith.getKey())) continue;
                hasConflicts = true;
            }
            if (hasConflicts) continue;
            enchantments.merge(entry.getKey(), entry.getValue(), (a, b) -> {
                int maxLevel = ((Enchantment)entry.getKey()).getMaxLevel();
                return this.combineEnchantmentLevels(maxLevel, (int)a, (int)b);
            });
        }
        return enchantments;
    }

    private int combineEnchantmentLevels(int maxLevel, int lvl1, int lvl2) {
        if (lvl1 == lvl2) {
            if (maxLevel <= lvl1 && !this.bypassVanillaMaxLevel.getValue().booleanValue()) {
                return maxLevel;
            }
            if (this.hasCustomMaxLevel.getValue().booleanValue()) {
                return lvl1 + 1 > this.customMaxLevel.getValue() ? this.customMaxLevel.getValue() : lvl1 + 1;
            }
            return lvl1 + 1;
        }
        int highestLevel = Math.max(lvl1, lvl2);
        if (maxLevel <= highestLevel && !this.bypassVanillaMaxLevel.getValue().booleanValue()) {
            return maxLevel;
        }
        if (this.hasCustomMaxLevel.getValue().booleanValue()) {
            return highestLevel > this.customMaxLevel.getValue() ? this.customMaxLevel.getValue() : highestLevel;
        }
        return highestLevel;
    }
}

