/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.profiler;

import io.github.thebusybiscuit.slimefun4.core.services.profiler.SlimefunProfiler;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;

public enum SummaryOrderType {
    HIGHEST,
    LOWEST,
    AVERAGE;


    @ParametersAreNonnullByDefault
    List<Map.Entry<String, Long>> sort(SlimefunProfiler profiler, Set<Map.Entry<String, Long>> entrySet) {
        switch (this) {
            case HIGHEST: {
                return entrySet.stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toList());
            }
            case LOWEST: {
                return entrySet.stream().sorted(Comparator.comparingLong(Map.Entry::getValue)).collect(Collectors.toList());
            }
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (Map.Entry<String, Long> entry : entrySet) {
            int count = profiler.getBlocksOfId(entry.getKey());
            long avg = count > 0 ? entry.getValue() / (long)count : entry.getValue();
            map.put(entry.getKey(), avg);
        }
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toList());
    }
}

