/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.inventory;

import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class DirtyChestMenu
extends ChestMenu {
    protected final BlockMenuPreset preset;
    protected int changes = 1;

    public DirtyChestMenu(@Nonnull BlockMenuPreset preset) {
        super(preset.getTitle());
        this.preset = preset;
    }

    public boolean hasViewer() {
        Inventory inv = this.toInventory();
        return inv != null && !inv.getViewers().isEmpty();
    }

    public void markDirty() {
        ++this.changes;
    }

    public boolean isDirty() {
        return this.changes > 0;
    }

    public int getUnsavedChanges() {
        return this.changes;
    }

    @Nonnull
    public BlockMenuPreset getPreset() {
        return this.preset;
    }

    public boolean canOpen(Block b, Player p) {
        return this.preset.canOpen(b, p);
    }

    @Override
    public void open(Player ... players) {
        super.open(players);
        this.markDirty();
    }

    public void close() {
        for (HumanEntity human : new ArrayList(this.toInventory().getViewers())) {
            human.closeInventory();
        }
    }

    public boolean fits(@Nonnull ItemStack item, int ... slots) {
        for (int slot : slots) {
            if (this.getItemInSlot(slot) != null) continue;
            return true;
        }
        return InvUtils.fits(this.toInventory(), ItemStackWrapper.wrap(item), slots);
    }

    @Nullable
    public ItemStack pushItem(ItemStack item, int ... slots) {
        if (item == null || item.getType() == Material.AIR) {
            throw new IllegalArgumentException("Cannot push null or AIR");
        }
        ItemStackWrapper wrapper = null;
        int amount = item.getAmount();
        for (int slot : slots) {
            if (amount <= 0) break;
            ItemStack stack = this.getItemInSlot(slot);
            if (stack == null) {
                this.replaceExistingItem(slot, item);
                return null;
            }
            int maxStackSize = Math.min(stack.getMaxStackSize(), this.toInventory().getMaxStackSize());
            if (stack.getAmount() >= maxStackSize) continue;
            if (wrapper == null) {
                wrapper = ItemStackWrapper.wrap(item);
            }
            if (!ItemUtils.canStack(wrapper, stack)) continue;
            stack.setAmount(Math.min(stack.getAmount() + item.getAmount(), maxStackSize));
            item.setAmount(amount -= maxStackSize - stack.getAmount());
        }
        if (amount > 0) {
            return new CustomItemStack(item, amount);
        }
        return null;
    }

    public void consumeItem(int slot) {
        this.consumeItem(slot, 1);
    }

    public void consumeItem(int slot, int amount) {
        this.consumeItem(slot, amount, false);
    }

    public void consumeItem(int slot, int amount, boolean replaceConsumables) {
        ItemUtils.consumeItem(this.getItemInSlot(slot), amount, replaceConsumables);
        this.markDirty();
    }

    @Override
    public void replaceExistingItem(int slot, ItemStack item) {
        this.replaceExistingItem(slot, item, true);
    }

    public void replaceExistingItem(int slot, ItemStack item, boolean event) {
        if (event) {
            ItemStack previous = this.getItemInSlot(slot);
            item = this.preset.onItemStackChange(this, slot, previous, item);
        }
        super.replaceExistingItem(slot, item);
        this.markDirty();
    }
}

