/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import io.github.thebusybiscuit.slimefun4.core.services.github.IssuesCallback;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.JsonNode;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.json.JSONArray;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.json.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

class GitHubIssuesConnector
extends GitHubConnector {
    private final IssuesCallback callback;

    @ParametersAreNonnullByDefault
    GitHubIssuesConnector(GitHubService github, String repository, IssuesCallback callback) {
        super(github, repository);
        this.callback = callback;
    }

    @Override
    public void onSuccess(@Nonnull JsonNode response) {
        if (response.isArray()) {
            JSONArray array = response.getArray();
            int issues = 0;
            int pullRequests = 0;
            for (int i = 0; i < array.length(); ++i) {
                JSONObject obj = array.getJSONObject(i);
                if (obj.has("pull_request")) {
                    ++pullRequests;
                    continue;
                }
                ++issues;
            }
            this.callback.accept(issues, pullRequests);
        } else {
            Slimefun.logger().log(Level.WARNING, "Received an unusual answer from GitHub, possibly a timeout? ({0})", response);
        }
    }

    @Override
    public String getFileName() {
        return "issues";
    }

    @Override
    public String getEndpoint() {
        return "/issues";
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("per_page", 100);
        return parameters;
    }
}

