/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.guide.options;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.core.SlimefunRegistry;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideOption;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideSettings;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

class FireworksOption
implements SlimefunGuideOption<Boolean> {
    FireworksOption() {
    }

    @Override
    public SlimefunAddon getAddon() {
        return Slimefun.instance();
    }

    public NamespacedKey getKey() {
        return new NamespacedKey((Plugin)Slimefun.instance(), "research_fireworks");
    }

    @Override
    public Optional<ItemStack> getDisplayItem(Player p, ItemStack guide) {
        SlimefunRegistry registry = Slimefun.getRegistry();
        if (registry.isResearchingEnabled() && registry.isResearchFireworkEnabled()) {
            boolean enabled = this.getSelectedOption(p, guide).orElse(true);
            CustomItemStack item = new CustomItemStack(Material.FIREWORK_ROCKET, "&bFireworks: &" + (enabled ? "aYes" : "4No"), "", "&7You can now toggle whether you", "&7will be presented with a big firework", "&7upon researching an item.", "", "&7\u21e8 &eClick to " + (enabled ? "disable" : "enable") + " your fireworks");
            return Optional.of(item);
        }
        return Optional.empty();
    }

    @Override
    public void onClick(Player p, ItemStack guide) {
        this.setSelectedOption(p, guide, this.getSelectedOption(p, guide).orElse(true) == false);
        SlimefunGuideSettings.openSettings(p, guide);
    }

    @Override
    public Optional<Boolean> getSelectedOption(Player p, ItemStack guide) {
        NamespacedKey key = this.getKey();
        boolean value = !PersistentDataAPI.hasByte((PersistentDataHolder)p, key) || PersistentDataAPI.getByte((PersistentDataHolder)p, key) == 1;
        return Optional.of(value);
    }

    @Override
    public void setSelectedOption(Player p, ItemStack guide, Boolean value) {
        PersistentDataAPI.setByte((PersistentDataHolder)p, this.getKey(), value != false ? (byte)1 : 0);
    }
}

