/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.gadgets;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import io.github.thebusybiscuit.slimefun4.core.handlers.EntityInteractHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.ToolUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.gadgets.MultiToolMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MultiTool
extends SlimefunItem
implements Rechargeable {
    private static final float COST = 0.3f;
    private final Map<UUID, Integer> selectedMode = new HashMap<UUID, Integer>();
    private final List<MultiToolMode> modes = new ArrayList<MultiToolMode>();
    private final float capacity;

    @ParametersAreNonnullByDefault
    public MultiTool(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, float capacity, String ... items) {
        super(itemGroup, item, recipeType, recipe);
        for (int i = 0; i < items.length; ++i) {
            this.modes.add(new MultiToolMode(this, i, items[i]));
        }
        this.capacity = capacity;
    }

    @Override
    public float getMaxItemCharge(ItemStack item) {
        return this.capacity;
    }

    private int nextIndex(int i) {
        int index = i;
        do {
            if (++index < this.modes.size()) continue;
            index = 0;
        } while (index != i && !this.modes.get(index).isEnabled());
        return index;
    }

    @Nonnull
    protected ItemUseHandler getItemUseHandler() {
        return e -> {
            Player p = e.getPlayer();
            ItemStack item = e.getItem();
            e.cancel();
            int index = this.selectedMode.getOrDefault(p.getUniqueId(), 0);
            if (!p.isSneaking()) {
                SlimefunItem sfItem;
                if (this.removeItemCharge(item, 0.3f) && (sfItem = this.modes.get(index).getItem()) != null) {
                    sfItem.callItemHandler(ItemUseHandler.class, handler -> handler.onRightClick(e));
                }
            } else {
                SlimefunItem selectedItem = this.modes.get(index = this.nextIndex(index)).getItem();
                String itemName = selectedItem != null ? selectedItem.getItemName() : "Unknown";
                Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.multi-tool.mode-change", true, msg -> msg.replace("%device%", "Multi Tool").replace("%mode%", ChatColor.stripColor((String)itemName)));
                this.selectedMode.put(p.getUniqueId(), index);
            }
        };
    }

    @Nonnull
    private ToolUseHandler getToolUseHandler() {
        return (e, tool, fortune, drops) -> {
            Slimefun.getLocalization().sendMessage((CommandSender)e.getPlayer(), "messages.multi-tool.not-shears");
            e.setCancelled(true);
        };
    }

    @Nonnull
    private EntityInteractHandler getEntityInteractionHandler() {
        return (e, item, offhand) -> {
            switch (e.getRightClicked().getType()) {
                case MUSHROOM_COW: 
                case SHEEP: 
                case SNOWMAN: {
                    Slimefun.getLocalization().sendMessage((CommandSender)e.getPlayer(), "messages.multi-tool.not-shears");
                    e.setCancelled(true);
                    break;
                }
            }
        };
    }

    @Override
    public void preRegister() {
        super.preRegister();
        this.addItemHandler(this.getItemUseHandler());
        this.addItemHandler(this.getToolUseHandler());
        this.addItemHandler(this.getEntityInteractionHandler());
    }
}

