/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.magical.runes;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemDropHandler;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SoulboundRune
extends SimpleSlimefunItem<ItemDropHandler> {
    private static final double RANGE = 1.5;

    @ParametersAreNonnullByDefault
    public SoulboundRune(ItemGroup itemGroup, SlimefunItemStack item, RecipeType type, ItemStack[] recipe) {
        super(itemGroup, item, type, recipe);
    }

    @Override
    @Nonnull
    public ItemDropHandler getItemHandler() {
        return (e, p, item) -> {
            if (this.isItem(item.getItemStack())) {
                if (!this.canUse(p, true)) {
                    return true;
                }
                Slimefun.runSync(() -> this.activate(p, item), 20L);
                return true;
            }
            return false;
        };
    }

    private void activate(@Nonnull Player p, @Nonnull Item rune) {
        if (!rune.isValid()) {
            return;
        }
        Location l = rune.getLocation();
        Collection entites = l.getWorld().getNearbyEntities(l, 1.5, 1.5, 1.5, this::findCompatibleItem);
        Optional optional = entites.stream().findFirst();
        if (optional.isPresent()) {
            Item item = (Item)optional.get();
            ItemStack itemStack = item.getItemStack();
            if (itemStack.getAmount() == 1) {
                l.getWorld().strikeLightningEffect(l);
                Slimefun.runSync(() -> {
                    if (rune.isValid() && item.isValid() && itemStack.getAmount() == 1) {
                        l.getWorld().createExplosion(l, 0.0f);
                        SoundEffect.SOULBOUND_RUNE_RITUAL_SOUND.playAt(l, SoundCategory.PLAYERS);
                        item.remove();
                        rune.remove();
                        SlimefunUtils.setSoulbound(itemStack, true);
                        l.getWorld().dropItemNaturally(l, itemStack);
                        Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.soulbound-rune.success", true);
                    } else {
                        Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.soulbound-rune.fail", true);
                    }
                }, 10L);
            } else {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "messages.soulbound-rune.fail", true);
            }
        }
    }

    private boolean findCompatibleItem(@Nonnull Entity entity) {
        if (entity instanceof Item) {
            Item item = (Item)entity;
            return item.getPickupDelay() <= 0 && !SlimefunUtils.isSoulbound(item.getItemStack()) && !this.isItem(item.getItemStack());
        }
        return false;
    }
}

