/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.androids;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidType;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.ProgrammableAndroid;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.RandomizedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

public class FishermanAndroid
extends ProgrammableAndroid {
    private final RandomizedSet<ItemStack> fishingLoot = new RandomizedSet();

    @ParametersAreNonnullByDefault
    public FishermanAndroid(ItemGroup itemGroup, int tier, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, tier, item, recipeType, recipe);
        for (Material fish : Tag.ITEMS_FISHES.getValues()) {
            this.fishingLoot.add(new ItemStack(fish), 25.0f);
        }
        this.fishingLoot.add(new ItemStack(Material.BONE), 10.0f);
        this.fishingLoot.add(new ItemStack(Material.STRING), 10.0f);
        this.fishingLoot.add(new ItemStack(Material.INK_SAC), 8.0f);
        this.fishingLoot.add(new ItemStack(Material.KELP), 6.0f);
        this.fishingLoot.add(new ItemStack(Material.STICK), 5.0f);
        this.fishingLoot.add(new ItemStack(Material.ROTTEN_FLESH), 3.0f);
        this.fishingLoot.add(new ItemStack(Material.LEATHER), 2.0f);
        this.fishingLoot.add(new ItemStack(Material.BAMBOO), 3.0f);
        this.fishingLoot.add(new ItemStack(Material.SADDLE), 1.0f);
        this.fishingLoot.add(new ItemStack(Material.NAME_TAG), 1.0f);
        this.fishingLoot.add(new ItemStack(Material.NAUTILUS_SHELL), 1.0f);
    }

    @Override
    public AndroidType getAndroidType() {
        return AndroidType.FISHERMAN;
    }

    @Override
    protected void fish(Block b, BlockMenu menu) {
        Block water = b.getRelative(BlockFace.DOWN);
        if (water.getType() == Material.WATER) {
            SoundEffect.FISHERMAN_ANDROID_FISHING_SOUND.playAt(water);
            if (ThreadLocalRandom.current().nextInt(100) < 10 * this.getTier()) {
                ItemStack drop = this.fishingLoot.getRandom();
                menu.pushItem(drop.clone(), this.getOutputSlots());
            }
        }
    }
}

