/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.items;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

public class ItemSetting<T> {
    private final SlimefunItem item;
    private final String key;
    private final T defaultValue;
    private T value;

    @ParametersAreNonnullByDefault
    public ItemSetting(SlimefunItem item, String key, T defaultValue) {
        Validate.notNull(item, "The provided SlimefunItem must not be null!");
        Validate.notNull(key, "The key of an ItemSetting is not allowed to be null!");
        Validate.notNull(defaultValue, "The default value of an ItemSetting is not allowed to be null!");
        this.item = item;
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public boolean validateInput(T input) {
        return input != null;
    }

    public void update(@Nonnull T newValue) {
        if (!this.validateInput(newValue)) {
            throw new IllegalArgumentException("The passed value was not valid. (Maybe null?)");
        }
        this.value = newValue;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    protected SlimefunItem getItem() {
        return this.item;
    }

    @Nonnull
    public T getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (Slimefun.instance().isUnitTest()) {
            throw new IllegalStateException("ItemSetting '" + this.key + "' was invoked but was not initialized yet.");
        }
        this.item.warn("ItemSetting '" + this.key + "' was invoked but was not initialized yet.");
        return this.defaultValue;
    }

    @Nonnull
    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isType(@Nonnull Class<?> c) {
        return c.isInstance(this.defaultValue);
    }

    @Nonnull
    protected String getErrorMessage() {
        return "Only '" + this.defaultValue.getClass().getSimpleName() + "' values are allowed!";
    }

    public void reload() {
        Validate.notNull(this.item, "Cannot apply settings for a non-existing SlimefunItem");
        Slimefun.getItemCfg().setDefaultValue(this.item.getId() + "." + this.getKey(), this.getDefaultValue());
        Object configuredValue = Slimefun.getItemCfg().getValue(this.item.getId() + "." + this.getKey());
        if (this.defaultValue.getClass().isInstance(configuredValue) || configuredValue instanceof List && this.defaultValue instanceof List) {
            Object newValue = configuredValue;
            if (this.validateInput(newValue)) {
                this.value = newValue;
            } else {
                this.item.warn("We have found an invalid config setting in your Items.yml!\n  at \"" + this.item.getId() + "." + this.getKey() + "\"\n  " + configuredValue + " is not a valid input!\n" + this.getErrorMessage());
            }
        } else {
            this.value = this.defaultValue;
            String found = configuredValue == null ? "null" : configuredValue.getClass().getSimpleName();
            this.item.warn("We have found an invalid config setting in your Items.yml!\nPlease only use settings that are valid.\n  at \"" + this.item.getId() + "." + this.getKey() + "\"\n  Expected \"" + this.defaultValue.getClass().getSimpleName() + "\" but found: \"" + found + "\"");
        }
    }

    public String toString() {
        T currentValue = this.value != null ? this.value : this.defaultValue;
        return this.getClass().getSimpleName() + " {" + this.getKey() + " = " + currentValue + " (default: " + this.getDefaultValue() + ")";
    }

    public final int hashCode() {
        return Objects.hash(this.item, this.key);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof ItemSetting) {
            ItemSetting setting = (ItemSetting)obj;
            return Objects.equals(this.getKey(), setting.getKey()) && Objects.equals(this.getItem(), setting.getItem());
        }
        return false;
    }
}

