/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.Config;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.HttpRequestSummary;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.HttpResponseSummary;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.RawResponse;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.ResponseSummary;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RawResponseBase
implements RawResponse {
    private static final Pattern CHARSET_PATTERN = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)");
    protected Config config;
    private final HttpRequestSummary reqSum;

    protected RawResponseBase(Config config, HttpRequestSummary reqSum) {
        this.config = config;
        this.reqSum = reqSum;
    }

    protected String getCharSet() {
        String contentType = this.getContentType();
        String responseCharset = this.getCharsetFromContentType(contentType);
        if (responseCharset != null && !responseCharset.trim().equals("")) {
            return responseCharset;
        }
        return this.config.getDefaultResponseEncoding();
    }

    private String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = CHARSET_PATTERN.matcher(contentType);
        if (m.find()) {
            return m.group(1).trim().toUpperCase();
        }
        return null;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public HttpResponseSummary toSummary() {
        return new ResponseSummary(this);
    }

    @Override
    public HttpRequestSummary getRequestSummary() {
        return this.reqSum;
    }
}

